/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.tablestore.TablestoreClient;
import com.facebook.presto.tablestore.TablestoreColumnHandle;
import com.facebook.presto.tablestore.TablestoreConnectorId;
import com.facebook.presto.tablestore.TablestoreErrorCode;
import com.facebook.presto.tablestore.TablestoreInsertTableHandle;
import com.facebook.presto.tablestore.TablestoreTableHandle;
import com.facebook.presto.tablestore.TablestoreTableLayoutHandle;
import com.facebook.presto.tablestore.model.TablestoreAccount;
import com.facebook.presto.tablestore.model.TablestoreColumn;
import com.facebook.presto.tablestore.model.TablestoreSchema;
import com.facebook.presto.tablestore.model.TablestoreTable;
import com.facebook.presto.tablestore.schema.TablestoreSchemaProperties;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class TablestoreMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(TablestoreMetadata.class);
    private final String connectorId;
    private final TablestoreClient tablestoreClient;

    @Inject
    public TablestoreMetadata(TablestoreConnectorId connectorId, TablestoreClient tablestoreClient) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.tablestoreClient = Objects.requireNonNull(tablestoreClient, "client is null");
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        log.info("create schema: %s", new Object[]{properties});
        Optional<String> instanceName = TablestoreSchemaProperties.getInstanceName(properties);
        Optional<String> endpoint = TablestoreSchemaProperties.getEndpoint(properties);
        Optional<String> accessId = TablestoreSchemaProperties.getAccessId(properties);
        Optional<String> accessKey = TablestoreSchemaProperties.getAccessKey(properties);
        Optional<String> stsToken = TablestoreSchemaProperties.getSTSToken(properties);
        Preconditions.checkArgument((instanceName.isPresent() && !Strings.isNullOrEmpty((String)instanceName.get()) ? 1 : 0) != 0, (Object)"Instance name is required when creating schema.");
        Preconditions.checkArgument((endpoint.isPresent() && !Strings.isNullOrEmpty((String)endpoint.get()) ? 1 : 0) != 0, (Object)"Endpoint is required when creating schema.");
        Preconditions.checkArgument((accessId.isPresent() && !Strings.isNullOrEmpty((String)accessId.get()) ? 1 : 0) != 0, (Object)"Access id is required when creating schema.");
        Preconditions.checkArgument((accessKey.isPresent() && !Strings.isNullOrEmpty((String)accessKey.get()) ? 1 : 0) != 0, (Object)"Access key is required when creating schema.");
        TablestoreAccount account = new TablestoreAccount(accessId.get(), accessKey.get(), stsToken.isPresent() ? stsToken.get() : null);
        TablestoreSchema schema = new TablestoreSchema(schemaName, instanceName.get(), endpoint.get(), account);
        this.tablestoreClient.createSchema(schema);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        int tableCount = this.tablestoreClient.getTableNames(schemaName).size();
        log.info("drop schema [%s] which has %d tables.", new Object[]{schemaName, tableCount});
        if (tableCount > 0) {
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.OPERATION_FORBIDDEN, "Drop tables before dropping schema.");
        }
        this.tablestoreClient.dropSchema(schemaName);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.tablestoreClient.createTable(tableMetadata, ignoreExisting);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.tablestoreClient.dropTable((TablestoreTableHandle)tableHandle);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.listSchemaNames();
    }

    public List<String> listSchemaNames() {
        log.debug("list schema names.");
        return ImmutableList.copyOf(this.tablestoreClient.getSchemaNames());
    }

    public TablestoreTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        log.debug("get table handle");
        if (!this.listSchemaNames(session).contains(tableName.getSchemaName())) {
            return null;
        }
        TablestoreTable table = this.tablestoreClient.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new TablestoreTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName());
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        log.info("Get table layouts with constraint domain [%s].", new Object[]{constraint.getSummary().toString(session.getSqlFunctionProperties())});
        TablestoreTableHandle tableHandle = (TablestoreTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new TablestoreTableLayoutHandle(tableHandle, (TupleDomain<ColumnHandle>)constraint.getSummary(), desiredColumns));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        log.debug("get table layout");
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        log.debug("get table metadata");
        TablestoreTableHandle tablestoreTableHandle = (TablestoreTableHandle)table;
        Preconditions.checkArgument((boolean)tablestoreTableHandle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        SchemaTableName tableName = new SchemaTableName(tablestoreTableHandle.getSchemaName(), tablestoreTableHandle.getTableName());
        return this.getTableMetadata(tableName);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaNameOptional) {
        log.debug("list tables with schema %s", new Object[]{schemaNameOptional.toString()});
        Object schemaNames = schemaNameOptional.isPresent() ? ImmutableSet.of((Object)schemaNameOptional.get()) : this.tablestoreClient.getSchemaNames();
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator iterator = schemaNames.iterator();
        while (iterator.hasNext()) {
            String schemaName = (String)iterator.next();
            for (String tableName : this.tablestoreClient.getTableNames(schemaName)) {
                builder.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        log.info("get column handles");
        TablestoreTableHandle tablestoreTableHandle = (TablestoreTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)tablestoreTableHandle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        TablestoreTable table = this.tablestoreClient.getTable(tablestoreTableHandle.getSchemaName(), tablestoreTableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(tablestoreTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        for (TablestoreColumn column : table.getColumns()) {
            columnHandles.put((Object)column.getName(), (Object)new TablestoreColumnHandle(this.connectorId, column.getName(), column.getOriginName(), column.getMetadata().getType(), index, column.isPrimaryKey(), column.getOrdinalPosition()));
            ++index;
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        log.debug("list table columns");
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        log.debug("get table metadata");
        if (!this.listSchemaNames().contains(tableName.getSchemaName())) {
            return null;
        }
        TablestoreTable table = this.tablestoreClient.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new ConnectorTableMetadata(tableName, table.getColumnsMetadata());
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        log.debug("list tables");
        if (prefix.getSchemaName() == null) {
            return this.listTables(session, Optional.of(prefix.getSchemaName()));
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        log.debug("get column metadata");
        return ((TablestoreColumnHandle)columnHandle).getColumnMetadata();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        TablestoreTableHandle tablestoreTableHandle = (TablestoreTableHandle)tableHandle;
        log.info("Get insert table handle: [%s.%s].", new Object[]{tablestoreTableHandle.getSchemaName(), tablestoreTableHandle.getTableName()});
        TablestoreTable table = this.tablestoreClient.getTable(tablestoreTableHandle.getSchemaName(), tablestoreTableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(tablestoreTableHandle.toSchemaTableName());
        }
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        int index = 0;
        for (TablestoreColumn column : table.getColumns()) {
            columnHandles.add((Object)new TablestoreColumnHandle(tablestoreTableHandle.getConnectorId(), column.getName(), column.getOriginName(), column.getMetadata().getType(), index, column.isPrimaryKey(), column.getOrdinalPosition()));
            ++index;
        }
        return new TablestoreInsertTableHandle(tablestoreTableHandle.getConnectorId(), tablestoreTableHandle.getSchemaName(), tablestoreTableHandle.getTableName(), (List<TablestoreColumnHandle>)columnHandles.build());
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }
}

