/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.writer.WriterConfig;
import com.facebook.airlift.configuration.Config;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.tablestore.TablestoreErrorCode;

public class TablestoreConfig {
    SchemaMode schemaMode;
    String schema;
    String metaInstance;
    String metaInstanceEndpoint;
    String metaInstanceAccessId;
    String metaInstanceAccessKey;
    String metaTable;
    boolean autoCreateMetaTable;
    int maxSplits = 5;
    int splitSizeInMB = 10;
    boolean enablePartitionPruning = true;
    boolean enableOptimizeBySecondaryIndex = true;
    boolean enableOptimizeBySearchIndex = true;
    long rowsBufferForSinkPerTable = 4096L;
    boolean enableScanWithFilter = true;
    int maxFiltersPushDown = 20;
    boolean enableBulkRead;
    long tableMetaCacheDurationInSeconds = 60L;
    int tableMetaCacheMaximumSize = 1000;
    long tableSplitsCacheDurationInSeconds = 86400L;
    int tableSplitsCacheMaximumSize = 1000;

    @Config(value="tablestore.schema-mode")
    public TablestoreConfig setSchemaMode(String mode) {
        if (mode.equalsIgnoreCase("file")) {
            this.schemaMode = SchemaMode.FILE;
        } else if (mode.equalsIgnoreCase("meta-table")) {
            this.schemaMode = SchemaMode.META_TABLE;
        } else {
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.INVALID_CONFIG, "Unrecognized schema mode: " + mode);
        }
        return this;
    }

    @Config(value="tablestore.schema-file")
    public TablestoreConfig setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    @Config(value="tablestore.meta-instance")
    public TablestoreConfig setMetaInstance(String metaInstance) {
        this.metaInstance = metaInstance;
        return this;
    }

    @Config(value="tablestore.endpoint")
    public TablestoreConfig setMetaInstanceEndpoint(String metaInstanceEndpoint) {
        this.metaInstanceEndpoint = metaInstanceEndpoint;
        return this;
    }

    @Config(value="tablestore.accessid")
    public TablestoreConfig setMetaInstanceAccessId(String metaInstanceAccessId) {
        this.metaInstanceAccessId = metaInstanceAccessId;
        return this;
    }

    @Config(value="tablestore.accesskey")
    public TablestoreConfig setMetaInstanceAccessKey(String metaInstanceAccessKey) {
        this.metaInstanceAccessKey = metaInstanceAccessKey;
        return this;
    }

    @Config(value="tablestore.meta-table")
    public TablestoreConfig setMetaTable(String metaTable) {
        this.metaTable = metaTable;
        return this;
    }

    @Config(value="tablestore.auto-create-meta-table")
    public TablestoreConfig setAutoCreateMetaTable(boolean autoCreateMetaTable) {
        this.autoCreateMetaTable = autoCreateMetaTable;
        return this;
    }

    @Config(value="tablestore.split-size-in-mb")
    public TablestoreConfig setSplitSizeInMB(int splitSizeInMB) {
        this.splitSizeInMB = splitSizeInMB;
        return this;
    }

    @Config(value="tablestore.max-splits")
    public TablestoreConfig setMaxSplits(int maxSplits) {
        this.maxSplits = maxSplits;
        return this;
    }

    @Config(value="tablestore.enable-partition-pruning")
    public TablestoreConfig setEnablePartitionPruning(boolean enablePartitionPruning) {
        this.enablePartitionPruning = enablePartitionPruning;
        return this;
    }

    @Config(value="tablestore.enable-optimize-by-secondary-index")
    public TablestoreConfig setEnableOptimizeBySecondaryIndex(boolean enableOptimizeBySecondaryIndex) {
        this.enableOptimizeBySecondaryIndex = enableOptimizeBySecondaryIndex;
        return this;
    }

    @Config(value="tablestore.enable-optimize-by-search-index")
    public TablestoreConfig setEnableOptimizeBySearchIndex(boolean enableOptimizeBySearchIndex) {
        this.enableOptimizeBySearchIndex = enableOptimizeBySearchIndex;
        return this;
    }

    @Config(value="tablestore.rows-buffer-for-sink-per-table")
    public TablestoreConfig setRowsBufferForSinkPerTable(long rowsBufferForSinkPerTable) {
        this.rowsBufferForSinkPerTable = rowsBufferForSinkPerTable;
        return this;
    }

    @Config(value="tablestore.enable-scan-with-filter")
    public TablestoreConfig setEnableScanWithFilter(boolean enableScanWithFilter) {
        this.enableScanWithFilter = enableScanWithFilter;
        return this;
    }

    @Config(value="tablestore.max-filters-push-down")
    public TablestoreConfig setMaxFiltersPushDown(int maxFiltersPushDown) {
        this.maxFiltersPushDown = maxFiltersPushDown;
        return this;
    }

    @Config(value="tablestore.enable-bulk-read")
    public TablestoreConfig setEnableBulkRead(boolean enableBulkRead) {
        this.enableBulkRead = enableBulkRead;
        return this;
    }

    @Config(value="tablestore.table-meta-cache-duration-in-seconds")
    public TablestoreConfig setTableMetaCacheDurationInSeconds(long cacheDurationInSeconds) {
        this.tableMetaCacheDurationInSeconds = cacheDurationInSeconds;
        return this;
    }

    @Config(value="tablestore.table-meta-cache-maximum-size")
    public TablestoreConfig setTableMetaCacheMaximumSize(int tableMetaCacheMaximumSize) {
        this.tableMetaCacheMaximumSize = tableMetaCacheMaximumSize;
        return this;
    }

    @Config(value="tablestore.table-splits-cache-duration-in-seconds")
    public TablestoreConfig setTableSplitsCacheDurationInSeconds(long cacheDurationInSeconds) {
        this.tableSplitsCacheDurationInSeconds = cacheDurationInSeconds;
        return this;
    }

    @Config(value="tablestore.table-splits-cache-maximum-size")
    public TablestoreConfig setTableSplitsCacheMaximumSize(int tableMetaCacheMaximumSize) {
        this.tableSplitsCacheMaximumSize = tableMetaCacheMaximumSize;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public SchemaMode getSchemaMode() {
        return this.schemaMode;
    }

    public int getMaxSplits() {
        return this.maxSplits;
    }

    public int getSplitSizeInMB() {
        return this.splitSizeInMB;
    }

    public boolean isEnablePartitionPruning() {
        return this.enablePartitionPruning;
    }

    public boolean isEnableOptimizeBySecondaryIndex() {
        return this.enableOptimizeBySecondaryIndex;
    }

    public boolean isEnableOptimizeBySearchIndex() {
        return this.enableOptimizeBySearchIndex;
    }

    public ClientConfiguration getClientConfig() {
        return new ClientConfiguration();
    }

    public boolean isEnableScanWithFilter() {
        return this.enableScanWithFilter;
    }

    public int getMaxFiltersPushDown() {
        return this.maxFiltersPushDown;
    }

    public boolean isEnableBulkRead() {
        return this.enableBulkRead;
    }

    public String getMetaInstance() {
        return this.metaInstance;
    }

    public String getMetaInstanceEndpoint() {
        return this.metaInstanceEndpoint;
    }

    public String getMetaInstanceAccessId() {
        return this.metaInstanceAccessId;
    }

    public String getMetaInstanceAccessKey() {
        return this.metaInstanceAccessKey;
    }

    public String getMetaTable() {
        return this.metaTable;
    }

    public boolean isAutoCreateMetaTable() {
        return this.autoCreateMetaTable;
    }

    public WriterConfig getWriterConfig() {
        WriterConfig writerConfig = new WriterConfig();
        writerConfig.setEnableSchemaCheck(false);
        return writerConfig;
    }

    public long getRowsBufferForSinkPerTable() {
        return this.rowsBufferForSinkPerTable;
    }

    public long getTableMetaCacheDurationInSeconds() {
        return this.tableMetaCacheDurationInSeconds;
    }

    public int getTableMetaCacheMaximumSize() {
        return this.tableMetaCacheMaximumSize;
    }

    public long getTableSplitsCacheDurationInSeconds() {
        return this.tableSplitsCacheDurationInSeconds;
    }

    public int getTableSplitsCacheMaximumSize() {
        return this.tableSplitsCacheMaximumSize;
    }

    public static enum SchemaMode {
        FILE,
        META_TABLE;

    }
}

