/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class TablestoreColumnHandle
implements ColumnHandle {
    private final String connectorId;
    private final String columnName;
    private final String originColumnName;
    private final Type columnType;
    private final int ordinalPosition;
    private final boolean primaryKey;
    private final int primaryKeyPosition;

    @JsonCreator
    public TablestoreColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="originColumnName") String originColumnName, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="isPrimaryKey") boolean primaryKey, @JsonProperty(value="primaryKeyPosition") int primaryKeyPosition) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.originColumnName = Objects.requireNonNull(originColumnName, "columnName is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.ordinalPosition = ordinalPosition;
        this.primaryKey = primaryKey;
        this.primaryKeyPosition = primaryKeyPosition;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public String getOriginColumnName() {
        return this.originColumnName;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    @JsonProperty
    public int getPrimaryKeyPosition() {
        return this.primaryKeyPosition;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.columnType);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.columnName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TablestoreColumnHandle other = (TablestoreColumnHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.columnName, other.columnName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("columnName", (Object)this.columnName).add("originColumnName", (Object)this.originColumnName).add("columnType", (Object)this.columnType).add("ordinalPosition", this.ordinalPosition).add("isPrimaryKey", this.primaryKey).add("primaryKeyPosition", this.primaryKeyPosition).toString();
    }
}

