/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.model.Split;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.tablestore.TablestoreAsyncPageSink;
import com.facebook.presto.tablestore.TablestoreConfig;
import com.facebook.presto.tablestore.TablestoreErrorCode;
import com.facebook.presto.tablestore.TablestoreTableHandle;
import com.facebook.presto.tablestore.model.TablestoreSchema;
import com.facebook.presto.tablestore.model.TablestoreTable;
import com.facebook.presto.tablestore.model.TablestoreTableMeta;
import com.facebook.presto.tablestore.schema.IMetaStore;
import com.facebook.presto.tablestore.schema.SchemaStoreFactory;
import com.facebook.presto.tablestore.schema.localstore.TablestoreSchemaJsonConf;
import com.facebook.presto.tablestore.util.TablestoreTableSerde;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class TablestoreClient {
    public static final Logger log = Logger.get(TablestoreClient.class);
    private final TablestoreConfig config;
    private final IMetaStore schemaStore;
    private final Map<SchemaTableName, TablestoreAsyncPageSink> pageSinks;
    private final Executor executor;
    private TablestoreTableSerde.Deserializer tableDeser;

    @Inject
    public TablestoreClient(TablestoreConfig config, JsonCodec<TablestoreSchemaJsonConf> schemaCodec, TablestoreTableSerde.Deserializer tableDeser) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(schemaCodec, "schemaCodec is null");
        this.config = config;
        if (config.getSchemaMode() == null || config.getSchemaMode() == TablestoreConfig.SchemaMode.FILE) {
            this.schemaStore = SchemaStoreFactory.createJsonConfigStore(config, schemaCodec);
        } else if (config.getSchemaMode() == TablestoreConfig.SchemaMode.META_TABLE) {
            this.schemaStore = SchemaStoreFactory.createOTSStore(config, tableDeser);
        } else {
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.INVALID_CONFIG, "Invalid schema mode: " + (Object)((Object)config.getSchemaMode()));
        }
        this.pageSinks = new ConcurrentHashMap<SchemaTableName, TablestoreAsyncPageSink>();
        this.executor = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void createSchema(TablestoreSchema schema) {
        this.schemaStore.createSchema(schema);
    }

    public Set<String> getSchemaNames() {
        return ImmutableSet.copyOf(this.schemaStore.listSchema());
    }

    public Set<String> getTableNames(String schema) {
        log.info("get table names in schema %s", new Object[]{schema});
        Objects.requireNonNull(schema, "schema is null");
        return ImmutableSet.copyOf(this.schemaStore.listTable(schema));
    }

    public TablestoreTable getTable(String schema, String tableName) {
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        return this.schemaStore.getTable(schema, tableName);
    }

    public TablestoreTableMeta describeTable(String schema, String tableName) {
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        return this.schemaStore.describeTable(schema, tableName);
    }

    public SyncClient getClient(String schema) {
        return this.schemaStore.getClient(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TablestoreAsyncPageSink getAsyncPageSink(String schema, String tableName) {
        TablestoreTable table = this.getTable(schema, tableName);
        SchemaTableName key = new SchemaTableName(schema, tableName);
        TablestoreAsyncPageSink pageSink = this.pageSinks.get(key);
        if (pageSink != null) {
            return pageSink;
        }
        Map<SchemaTableName, TablestoreAsyncPageSink> map = this.pageSinks;
        synchronized (map) {
            pageSink = this.pageSinks.get(key);
            if (pageSink != null) {
                return pageSink;
            }
            pageSink = new TablestoreAsyncPageSink(schema, this, this.config, table, this.executor);
            this.pageSinks.put(key, pageSink);
            return pageSink;
        }
    }

    public List<Split> getTableSplits(String schema, String tableName) {
        return this.schemaStore.getTableSplits(schema, tableName);
    }

    public void createTable(ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.schemaStore.createTable(tableMetadata, ignoreExisting);
    }

    public void dropSchema(String schemaName) {
        this.schemaStore.dropSchema(schemaName);
    }

    public void dropTable(TablestoreTableHandle tableHandle) {
        this.schemaStore.dropTable(tableHandle.getSchemaName(), tableHandle.getTableName());
    }
}

