/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.timeseries;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class TimeseriesKey
implements Comparable<TimeseriesKey> {
    private final String measurementName;
    private final String dataSource;
    private final SortedMap<String, String> tags = new TreeMap<String, String>();

    public TimeseriesKey(String measurementName, String dataSource) {
        this(measurementName, dataSource, null);
    }

    public TimeseriesKey(String measurementName, Map<String, String> tags) {
        this(measurementName, "", tags);
    }

    public TimeseriesKey(String measurementName, String dataSource, Map<String, String> tags) {
        Preconditions.checkStringNotNullAndEmpty(measurementName, "measurement should not be null or empty");
        this.measurementName = measurementName;
        this.dataSource = dataSource != null ? dataSource : "";
        if (tags != null) {
            this.tags.putAll(tags);
        }
    }

    public String getMeasurementName() {
        return this.measurementName;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public SortedMap<String, String> getTags() {
        return Collections.unmodifiableSortedMap(this.tags);
    }

    public String buildMetaCacheKey(String tableName) {
        int capacity = 0;
        capacity += tableName.length();
        capacity += this.measurementName.length();
        capacity += this.dataSource.length();
        capacity += 4;
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            capacity += entry.getKey().length() + entry.getValue().length() + 3;
        }
        StringBuilder sb = new StringBuilder(capacity);
        sb.append(tableName);
        sb.append((char)this.measurementName.length());
        sb.append(this.measurementName);
        sb.append((char)this.dataSource.length());
        sb.append(this.dataSource);
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            sb.append(entry.getKey());
            sb.append("\t");
            sb.append((char)entry.getValue().length());
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeseriesKey that = (TimeseriesKey)o;
        return Objects.equal((Object)this.measurementName, (Object)that.measurementName) && Objects.equal((Object)this.dataSource, (Object)that.dataSource) && Objects.equal(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.measurementName, this.dataSource, this.tags});
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    @Override
    public int compareTo(TimeseriesKey target) {
        int ret = this.measurementName.compareTo(target.measurementName);
        if (ret != 0) {
            return ret;
        }
        ret = this.dataSource.compareTo(target.dataSource);
        if (ret != 0) {
            return ret;
        }
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(this.tags.keySet());
        keys.addAll(target.tags.keySet());
        for (String key : keys) {
            String value = (String)this.tags.get(key);
            String targetValue = (String)target.tags.get(key);
            if (value == null && targetValue == null) continue;
            if (value == null) {
                return -1;
            }
            if (targetValue == null) {
                return 1;
            }
            ret = value.compareTo(targetValue);
            if (ret == 0) continue;
            return ret;
        }
        return ret;
    }
}

