/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import com.aliyun.ots.thirdparty.org.apache.HttpHost;
import com.aliyun.ots.thirdparty.org.apache.auth.AuthScope;
import com.aliyun.ots.thirdparty.org.apache.auth.NTCredentials;
import com.aliyun.ots.thirdparty.org.apache.client.config.RequestConfig;
import com.aliyun.ots.thirdparty.org.apache.impl.client.BasicCredentialsProvider;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.client.CloseableHttpAsyncClient;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.client.HttpAsyncClientBuilder;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.client.HttpAsyncClients;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.conn.PoolingNHttpClientConnectionManager;

class HttpFactory {
    HttpFactory() {
    }

    public static CloseableHttpAsyncClient createHttpAsyncClient(ClientConfiguration config, PoolingNHttpClientConnectionManager cm) {
        HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClients.custom();
        httpClientBuilder.setConnectionManager(cm);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(config.getConnectionTimeoutInMillisecond()).setSocketTimeout(config.getSocketTimeoutInMillisecond());
        if (config.getConnectionRequestTimeoutInMillisecond() > 0) {
            requestConfigBuilder.setConnectionRequestTimeout(config.getConnectionRequestTimeoutInMillisecond());
        }
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        httpClientBuilder.setUserAgent("ots-java-sdk 5.17.1");
        httpClientBuilder.disableCookieManagement();
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null) {
            if (proxyPort <= 0) {
                throw new ClientException("The proxy port is invalid. Please check your configuration.");
            }
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            httpClientBuilder.setProxy(proxy);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            if (proxyUsername != null && proxyPassword != null) {
                String proxyDomain = config.getProxyDomain();
                String proxyWorkstation = config.getProxyWorkstation();
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
                httpClientBuilder.setDefaultCredentialsProvider(credsProvider);
            }
        }
        return httpClientBuilder.build();
    }
}

