/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;

public class BasicCredentials
implements ServiceCredentials {
    protected String accessKeyId;
    protected String accessKeySecret;
    protected String securityToken;
    protected long expiredDurationSeconds;
    protected long startedTimeInMilliSeconds = 0L;
    protected double expiredFactor = 0.8;

    public BasicCredentials(String accessKeyId, String accessKeySecret, String securityToken) {
        this(accessKeyId, accessKeySecret, securityToken, 0L);
    }

    public BasicCredentials(String accessKeyId, String accessKeySecret, String securityToken, long expiredDurationSeconds) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
        this.expiredDurationSeconds = expiredDurationSeconds;
        this.startedTimeInMilliSeconds = System.currentTimeMillis();
    }

    public BasicCredentials withExpiredFactor(double expiredFactor) {
        this.expiredFactor = expiredFactor;
        return this;
    }

    public BasicCredentials withExpiredDuration(long expiredDurationSeconds) {
        this.expiredDurationSeconds = expiredDurationSeconds;
        return this;
    }

    @Override
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    @Override
    public String getSecurityToken() {
        return this.securityToken;
    }

    public boolean willSoonExpire() {
        if (this.expiredDurationSeconds == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        return (double)this.expiredDurationSeconds * this.expiredFactor < (double)(now - this.startedTimeInMilliSeconds) / 1000.0;
    }
}

