/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeserieswriter.handle;

import com.alicloud.openservices.tablestore.AsyncTimeseriesClientInterface;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesTableRow;
import com.alicloud.openservices.tablestore.timeserieswriter.TimeseriesRowEvent;
import com.alicloud.openservices.tablestore.timeserieswriter.callback.TimeseriesRowResult;
import com.alicloud.openservices.tablestore.timeserieswriter.config.TimeseriesBucketConfig;
import com.alicloud.openservices.tablestore.timeserieswriter.config.TimeseriesWriterConfig;
import com.alicloud.openservices.tablestore.timeserieswriter.group.TimeseriesRequestWithGroups;
import com.alicloud.openservices.tablestore.timeserieswriter.group.TimeseriesRowWithGroup;
import com.alicloud.openservices.tablestore.timeserieswriter.handle.TimeseriesWriterHandleStatistics;
import com.alicloud.openservices.tablestore.timeserieswriter.manager.TimeseriesBatchRequestManager;
import com.alicloud.openservices.tablestore.timeserieswriter.manager.TimeseriesRequestManager;
import com.lmax.disruptor.EventHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesRowEventHandler
implements EventHandler<TimeseriesRowEvent> {
    private final Logger logger = LoggerFactory.getLogger(TimeseriesRowEventHandler.class);
    private final AsyncTimeseriesClientInterface ots;
    private final Executor executor;
    private final TimeseriesWriterHandleStatistics timeseriesWriterHandleStatistics;
    private final Semaphore callbackSemaphore;
    private final Semaphore bucketSemaphore;
    private final Map<String, TimeseriesRequestManager> map;
    private final int bucketConcurrency;
    private final TimeseriesWriterConfig timeseriesWriterConfig;
    private final TimeseriesBucketConfig timeseriesBucketConfig;
    private TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> callback;

    public TimeseriesRowEventHandler(AsyncTimeseriesClientInterface ots, TimeseriesWriterConfig timeseriesWriterConfig, TimeseriesBucketConfig timeseriesBucketConfig, TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> callback, Executor executor, TimeseriesWriterHandleStatistics timeseriesWriterHandleStatistics, Semaphore semaphore) {
        this.ots = ots;
        this.timeseriesWriterConfig = timeseriesWriterConfig;
        this.timeseriesBucketConfig = timeseriesBucketConfig;
        int concurrency = timeseriesWriterConfig.getConcurrency();
        this.callbackSemaphore = semaphore;
        this.callback = callback;
        this.executor = executor;
        this.timeseriesWriterHandleStatistics = timeseriesWriterHandleStatistics;
        switch (timeseriesWriterConfig.getWriteMode()) {
            case SEQUENTIAL: {
                this.bucketConcurrency = 1;
                break;
            }
            default: {
                this.bucketConcurrency = concurrency;
            }
        }
        this.bucketSemaphore = new Semaphore(this.bucketConcurrency);
        this.map = new HashMap<String, TimeseriesRequestManager>();
    }

    public void setCallback(TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> callback) {
        this.callback = callback;
        for (Map.Entry<String, TimeseriesRequestManager> entry : this.map.entrySet()) {
            entry.setValue(new TimeseriesBatchRequestManager(this.ots, this.timeseriesWriterConfig, this.timeseriesBucketConfig, this.executor, this.timeseriesWriterHandleStatistics, callback, this.callbackSemaphore, this.bucketSemaphore));
        }
    }

    public void onEvent(TimeseriesRowEvent timeseriesRowEvent, long l, boolean b) throws Exception {
        boolean shouldWaitFlush = false;
        CountDownLatch latch = null;
        HashMap<String, TimeseriesRequestWithGroups> timeseriesRequestWithGroupsMap = new HashMap<String, TimeseriesRequestWithGroups>();
        if (timeseriesRowEvent.type == TimeseriesRowEvent.EventType.FLUSH) {
            int totalRowsCount = 0;
            for (Map.Entry<String, TimeseriesRequestManager> entry : this.map.entrySet()) {
                if (entry.getValue().getTotalRowsCount() <= 0) continue;
                timeseriesRequestWithGroupsMap.put(entry.getKey(), entry.getValue().makeRequest(entry.getKey()));
                totalRowsCount += entry.getValue().getTotalRowsCount();
            }
            this.logger.debug("FlushSignal with QueueSize: {}", (Object)totalRowsCount);
            shouldWaitFlush = true;
            latch = timeseriesRowEvent.latch;
        } else {
            boolean succeed;
            this.timeseriesWriterHandleStatistics.totalRowsCount.incrementAndGet();
            final TimeseriesTableRow timeseriesTableRow = timeseriesRowEvent.timeseriesTableRow;
            final TimeseriesRowWithGroup timeseriesRowWithGroup = new TimeseriesRowWithGroup(timeseriesRowEvent.timeseriesTableRow, timeseriesRowEvent.timeseriesGroup);
            if (!this.map.containsKey(timeseriesTableRow.getTableName())) {
                this.map.put(timeseriesTableRow.getTableName(), new TimeseriesBatchRequestManager(this.ots, this.timeseriesWriterConfig, this.timeseriesBucketConfig, this.executor, this.timeseriesWriterHandleStatistics, this.callback, this.callbackSemaphore, this.bucketSemaphore));
            }
            if (!(succeed = this.map.get(timeseriesTableRow.getTableName()).appendTimeseriesRow(timeseriesRowWithGroup))) {
                TimeseriesRequestWithGroups timeseriesRequestWithGroups = this.map.get(timeseriesTableRow.getTableName()).makeRequest(timeseriesTableRow.getTableName());
                if (timeseriesRequestWithGroups != null) {
                    timeseriesRequestWithGroupsMap.put(timeseriesTableRow.getTableName(), timeseriesRequestWithGroups);
                }
                if (!(succeed = this.map.get(timeseriesTableRow.getTableName()).appendTimeseriesRow(timeseriesRowWithGroup))) {
                    this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ((TimeseriesRowEventHandler)TimeseriesRowEventHandler.this).timeseriesWriterHandleStatistics.totalFailedRowsCount.incrementAndGet();
                            ClientException exception = new ClientException("Failed to append timeseries row into buffer.");
                            TimeseriesRowEventHandler.this.logger.error("RowChange Failed: ", (Throwable)exception);
                            timeseriesRowWithGroup.timeseriesGroup.failedOneRow(timeseriesRowWithGroup.timeseriesTableRow, exception);
                            if (TimeseriesRowEventHandler.this.callback != null) {
                                TimeseriesRowEventHandler.this.callback.onFailed(timeseriesTableRow, exception);
                            }
                        }
                    });
                }
            }
        }
        if (!timeseriesRequestWithGroupsMap.isEmpty()) {
            for (final Map.Entry entry : timeseriesRequestWithGroupsMap.entrySet()) {
                this.bucketSemaphore.acquire();
                this.callbackSemaphore.acquire();
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((TimeseriesRowEventHandler)TimeseriesRowEventHandler.this).timeseriesWriterHandleStatistics.totalRequestCount.incrementAndGet();
                        ((TimeseriesRequestManager)TimeseriesRowEventHandler.this.map.get(entry.getKey())).sendRequest((TimeseriesRequestWithGroups)entry.getValue());
                    }
                });
            }
        }
        if (shouldWaitFlush) {
            this.bucketSemaphore.acquire(this.bucketConcurrency);
            this.bucketSemaphore.release(this.bucketConcurrency);
            this.logger.debug("Finish bucket waitFlush.");
            latch.countDown();
        }
    }
}

