/*
 * Copyright (C) 2018-2020 Alibaba Group Holding Limited
 */

#ifndef __SAM_API_EXT_H__
#define __SAM_API_EXT_H__

#include "sam_api.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief execute File-layered block decryption (based on password).
 *
 * @param [in] context: Pointer to an initialized context.
 * @param [in] password: The password string used to derive content key.
 * @param [in] fd: The content file descriptor.
 * @param [in] offset: The offset of content to decrypt.
 * @param [in] size: The size of content to decrypt.
 * @param [out] out: The output buffer(offset is 0) to save decrypted content block.
 * @param [in]  out_len: The capacity of output buffer.
 *
 * @see error code definitions.
 */
sam_result sam_on_block_decryption(sam_context *context, char *password,
                  int fd, uint64_t offset, uint64_t size, uint8_t *out, uint64_t out_len);

#ifdef __cplusplus
}
#endif

#endif /* __SAM_API_EXT__ */
