/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source;

import java.util.function.Function;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;

public interface KeyGroupPruner<T> {
    public void open(FunctionContext var1);

    public boolean belongsToCurrentSubTask(T var1);

    public static boolean belongsToCurrentSubTask(RowData record, int bucketNum, int numberOfChannels, int indexOfCurrentSubTask, Function<RowData, Integer> calcChannelId) {
        int lowerBound = calcChannelId.apply(record);
        if (bucketNum > 1) {
            int upperBound = (lowerBound + bucketNum) % numberOfChannels;
            if (lowerBound < upperBound) {
                return indexOfCurrentSubTask >= lowerBound && indexOfCurrentSubTask < upperBound;
            }
            return indexOfCurrentSubTask < upperBound || indexOfCurrentSubTask >= lowerBound;
        }
        return lowerBound == indexOfCurrentSubTask;
    }
}

