/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.table;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.jdbc.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatement;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JdbcRowDataLookupFunction
extends LookupFunction {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcRowDataLookupFunction.class);
    private static final long serialVersionUID = 2L;
    private final String query;
    private final JdbcConnectionProvider connectionProvider;
    private final String[] keyNames;
    private final int maxRetryTimes;
    private final JdbcRowConverter jdbcRowConverter;
    private final JdbcRowConverter lookupKeyRowConverter;
    private transient FieldNamedPreparedStatement statement;

    public JdbcRowDataLookupFunction(InternalJdbcConnectionOptions options, int maxRetryTimes, String[] fieldNames, DataType[] fieldTypes, String[] keyNames, RowType rowType) {
        Preconditions.checkNotNull((Object)options, (String)"No JdbcOptions supplied.");
        Preconditions.checkNotNull((Object)fieldNames, (String)"No fieldNames supplied.");
        Preconditions.checkNotNull((Object)fieldTypes, (String)"No fieldTypes supplied.");
        Preconditions.checkNotNull((Object)keyNames, (String)"No keyNames supplied.");
        this.connectionProvider = new SimpleJdbcConnectionProvider(options);
        this.keyNames = keyNames;
        List<String> nameList = Arrays.asList(fieldNames);
        DataType[] keyTypes = (DataType[])Arrays.stream(keyNames).map(s -> {
            Preconditions.checkArgument((boolean)nameList.contains(s), (String)"keyName %s can't find in fieldNames %s.", (Object[])new Object[]{s, nameList});
            return fieldTypes[nameList.indexOf(s)];
        }).toArray(DataType[]::new);
        this.maxRetryTimes = maxRetryTimes;
        this.query = options.getDialect().getSelectFromStatement(options.getTableName(), fieldNames, keyNames);
        JdbcDialect jdbcDialect = options.getDialect();
        this.jdbcRowConverter = jdbcDialect.getRowConverter(rowType);
        this.lookupKeyRowConverter = jdbcDialect.getRowConverter(RowType.of((LogicalType[])((LogicalType[])Arrays.stream(keyTypes).map(DataType::getLogicalType).toArray(LogicalType[]::new))));
    }

    public void open(FunctionContext context) throws Exception {
        try {
            this.establishConnectionAndStatement();
        }
        catch (SQLException sqe) {
            throw new IllegalArgumentException("open() failed.", sqe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("JDBC driver class not found.", cnfe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<RowData> lookup(RowData keyRow) {
        int retry = 0;
        while (retry <= this.maxRetryTimes) {
            try {
                this.statement.clearParameters();
                this.statement = this.lookupKeyRowConverter.toExternal(keyRow, this.statement);
                try (ResultSet resultSet = this.statement.executeQuery();){
                    ArrayList<RowData> rows = new ArrayList<RowData>();
                    while (resultSet.next()) {
                        RowData row = this.jdbcRowConverter.toInternal(resultSet);
                        rows.add(row);
                    }
                    rows.trimToSize();
                    ArrayList<RowData> arrayList = rows;
                    return arrayList;
                }
            }
            catch (SQLException e) {
                LOG.error(String.format("JDBC executeBatch error, retry times = %d", retry), e);
                if (retry >= this.maxRetryTimes) {
                    throw new RuntimeException("Execution of JDBC statement failed.", e);
                }
                try {
                    if (!this.connectionProvider.isConnectionValid()) {
                        this.statement.close();
                        this.connectionProvider.closeConnection();
                        this.establishConnectionAndStatement();
                    }
                }
                catch (ClassNotFoundException | SQLException exception) {
                    LOG.error("JDBC connection is not valid, and reestablish connection failed", exception);
                    throw new RuntimeException("Reestablish JDBC connection failed", exception);
                }
                try {
                    Thread.sleep(1000L * (long)retry);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                ++retry;
            }
        }
        return Collections.emptyList();
    }

    private void establishConnectionAndStatement() throws SQLException, ClassNotFoundException {
        Connection dbConn = this.connectionProvider.getOrEstablishConnection();
        this.statement = FieldNamedPreparedStatement.prepareStatement(dbConn, this.query, this.keyNames);
    }

    public void close() throws IOException {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                LOG.info("JDBC statement could not be closed: " + e.getMessage());
            }
            finally {
                this.statement = null;
            }
        }
        this.connectionProvider.closeConnection();
    }

    @VisibleForTesting
    public Connection getDbConnection() {
        return this.connectionProvider.getConnection();
    }
}

