/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SimpleJdbcConnectionProvider
implements JdbcConnectionProvider,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleJdbcConnectionProvider.class);
    private static final long serialVersionUID = 1L;
    private final JdbcConnectionOptions jdbcOptions;
    private final Properties connectProperties;
    private transient Driver loadedDriver;
    private transient Connection connection;

    public SimpleJdbcConnectionProvider(JdbcConnectionOptions jdbcOptions) {
        this.jdbcOptions = jdbcOptions;
        this.connectProperties = new Properties();
    }

    public SimpleJdbcConnectionProvider(JdbcConnectionOptions jdbcOptions, Properties connectProperties) {
        this.jdbcOptions = jdbcOptions;
        this.connectProperties = connectProperties;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isConnectionValid() throws SQLException {
        return this.connection != null && this.connection.isValid(this.jdbcOptions.getConnectionCheckTimeoutSeconds());
    }

    private static Driver loadDriver(String driverName) throws SQLException, ClassNotFoundException {
        Preconditions.checkNotNull((Object)driverName);
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!driver.getClass().getName().equals(driverName)) continue;
            return driver;
        }
        Class<?> clazz = Class.forName(driverName, true, Thread.currentThread().getContextClassLoader());
        try {
            return (Driver)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new SQLException("Fail to create driver of class " + driverName, ex);
        }
    }

    private Driver getLoadedDriver() throws SQLException, ClassNotFoundException {
        if (this.loadedDriver == null) {
            this.loadedDriver = SimpleJdbcConnectionProvider.loadDriver(this.jdbcOptions.getDriverName());
        }
        return this.loadedDriver;
    }

    @Override
    public Connection getOrEstablishConnection() throws SQLException, ClassNotFoundException {
        if (this.connection != null) {
            return this.connection;
        }
        Properties info = new Properties();
        this.jdbcOptions.getUsername().ifPresent(user -> info.setProperty("user", (String)user));
        this.jdbcOptions.getPassword().ifPresent(password -> info.setProperty("password", (String)password));
        info.putAll((Map<?, ?>)this.connectProperties);
        if (this.jdbcOptions.getDriverName() == null) {
            this.connection = DriverManager.getConnection(this.jdbcOptions.getDbURL(), info);
        } else {
            Driver driver = this.getLoadedDriver();
            this.connection = driver.connect(this.jdbcOptions.getDbURL(), info);
            if (this.connection == null) {
                throw new SQLException("No suitable driver found for " + this.jdbcOptions.getDbURL(), "08001");
            }
        }
        return this.connection;
    }

    @Override
    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOG.warn("JDBC connection close failed.", e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Override
    public Connection reestablishConnection() throws SQLException, ClassNotFoundException {
        this.closeConnection();
        return this.getOrEstablishConnection();
    }

    static {
        DriverManager.getDrivers();
    }
}

