/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.header.ConnectHeaders;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.header.Header;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.header.Headers;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.ExtractField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.InsertField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.Transformation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.Requirements;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.SchemaUtil;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.data.Envelope;
import io.debezium.transforms.ExtractNewRecordStateConfigDefinition;
import io.debezium.transforms.SmtManager;
import io.debezium.util.BoundedConcurrentHashMap;
import io.debezium.util.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractNewRecordState<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractNewRecordState.class);
    private static final String PURPOSE = "source field insertion";
    private static final int SCHEMA_CACHE_SIZE = 64;
    private static final Pattern FIELD_SEPARATOR = Pattern.compile("\\.");
    private static final Pattern NEW_FIELD_SEPARATOR = Pattern.compile(":");
    private boolean dropTombstones;
    private ExtractNewRecordStateConfigDefinition.DeleteHandling handleDeletes;
    private List<FieldReference> additionalHeaders;
    private List<FieldReference> additionalFields;
    private String routeByField;
    private final ExtractField<R> afterDelegate = new ExtractField.Value();
    private final ExtractField<R> beforeDelegate = new ExtractField.Value();
    private final InsertField<R> removedDelegate = new InsertField.Value();
    private final InsertField<R> updatedDelegate = new InsertField.Value();
    private BoundedConcurrentHashMap<Schema, Schema> schemaUpdateCache;
    private SmtManager<R> smtManager;

    @Override
    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        this.smtManager = new SmtManager(config);
        Field.Set configFields = Field.setOf(ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES, ExtractNewRecordStateConfigDefinition.HANDLE_DELETES);
        if (!config.validateAndRecord(configFields, LOGGER::error)) {
            throw new ConnectException("Unable to validate config.");
        }
        this.dropTombstones = config.getBoolean(ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES);
        this.handleDeletes = ExtractNewRecordStateConfigDefinition.DeleteHandling.parse(config.getString(ExtractNewRecordStateConfigDefinition.HANDLE_DELETES));
        String addFieldsPrefix = config.getString(ExtractNewRecordStateConfigDefinition.ADD_FIELDS_PREFIX);
        String addHeadersPrefix = config.getString(ExtractNewRecordStateConfigDefinition.ADD_HEADERS_PREFIX);
        this.additionalFields = FieldReference.fromConfiguration(addFieldsPrefix, config.getString(ExtractNewRecordStateConfigDefinition.ADD_FIELDS));
        this.additionalHeaders = FieldReference.fromConfiguration(addHeadersPrefix, config.getString(ExtractNewRecordStateConfigDefinition.ADD_HEADERS));
        String routeFieldConfig = config.getString(ExtractNewRecordStateConfigDefinition.ROUTE_BY_FIELD);
        this.routeByField = routeFieldConfig.isEmpty() ? null : routeFieldConfig;
        HashMap delegateConfig = new LinkedHashMap<String, String>();
        delegateConfig.put("field", "before");
        this.beforeDelegate.configure(delegateConfig);
        delegateConfig = new HashMap();
        delegateConfig.put("field", "after");
        this.afterDelegate.configure(delegateConfig);
        delegateConfig = new HashMap();
        delegateConfig.put("static.field", "__deleted");
        delegateConfig.put("static.value", "true");
        this.removedDelegate.configure(delegateConfig);
        delegateConfig = new HashMap();
        delegateConfig.put("static.field", "__deleted");
        delegateConfig.put("static.value", "false");
        this.updatedDelegate.configure(delegateConfig);
        this.schemaUpdateCache = new BoundedConcurrentHashMap(64);
    }

    @Override
    public R apply(R record) {
        R newRecord;
        if (((ConnectRecord)record).value() == null) {
            if (this.dropTombstones) {
                LOGGER.trace("Tombstone {} arrived and requested to be dropped", ((ConnectRecord)record).key());
                return null;
            }
            if (!this.additionalHeaders.isEmpty()) {
                Headers headersToAdd = this.makeHeaders(this.additionalHeaders, (Struct)((ConnectRecord)record).value());
                headersToAdd.forEach(h -> record.headers().add((Header)h));
            }
            return record;
        }
        if (!this.smtManager.isValidEnvelope(record)) {
            return record;
        }
        if (!this.additionalHeaders.isEmpty()) {
            Headers headersToAdd = this.makeHeaders(this.additionalHeaders, (Struct)((ConnectRecord)record).value());
            headersToAdd.forEach(h -> record.headers().add((Header)h));
        }
        if (((ConnectRecord)(newRecord = this.afterDelegate.apply(record))).value() == null) {
            if (this.routeByField != null) {
                Struct recordValue = Requirements.requireStruct(((ConnectRecord)record).value(), "Read record to set topic routing for DELETE");
                String newTopicName = recordValue.getStruct("before").getString(this.routeByField);
                newRecord = this.setTopic(newTopicName, newRecord);
            }
            switch (this.handleDeletes) {
                case DROP: {
                    LOGGER.trace("Delete message {} requested to be dropped", ((ConnectRecord)record).key());
                    return null;
                }
                case REWRITE: {
                    LOGGER.trace("Delete message {} requested to be rewritten", ((ConnectRecord)record).key());
                    R oldRecord = this.beforeDelegate.apply(record);
                    oldRecord = this.addFields(this.additionalFields, record, oldRecord);
                    return this.removedDelegate.apply(oldRecord);
                }
            }
            return newRecord;
        }
        if (this.routeByField != null) {
            Struct recordValue = Requirements.requireStruct(((ConnectRecord)newRecord).value(), "Read record to set topic routing for CREATE / UPDATE");
            String newTopicName = recordValue.getString(this.routeByField);
            newRecord = this.setTopic(newTopicName, newRecord);
        }
        newRecord = this.addFields(this.additionalFields, record, newRecord);
        switch (this.handleDeletes) {
            case REWRITE: {
                LOGGER.trace("Insert/update message {} requested to be rewritten", ((ConnectRecord)record).key());
                return this.updatedDelegate.apply(newRecord);
            }
        }
        return newRecord;
    }

    private R setTopic(String updatedTopicValue, R record) {
        String topicName = updatedTopicValue == null ? ((ConnectRecord)record).topic() : updatedTopicValue;
        return ((ConnectRecord)record).newRecord(topicName, ((ConnectRecord)record).kafkaPartition(), ((ConnectRecord)record).keySchema(), ((ConnectRecord)record).key(), ((ConnectRecord)record).valueSchema(), ((ConnectRecord)record).value(), ((ConnectRecord)record).timestamp());
    }

    private Headers makeHeaders(List<FieldReference> additionalHeaders, Struct originalRecordValue) {
        ConnectHeaders headers = new ConnectHeaders();
        for (FieldReference fieldReference : additionalHeaders) {
            if (originalRecordValue == null) {
                if (!"op".equals(fieldReference.field)) continue;
                headers.addString(fieldReference.getNewField(), Envelope.Operation.DELETE.code());
                continue;
            }
            headers.add(fieldReference.getNewField(), fieldReference.getValue(originalRecordValue), fieldReference.getSchema(originalRecordValue.schema()));
        }
        return headers;
    }

    private R addFields(List<FieldReference> additionalFields, R originalRecord, R unwrappedRecord) {
        Struct value = Requirements.requireStruct(((ConnectRecord)unwrappedRecord).value(), PURPOSE);
        Struct originalRecordValue = (Struct)((ConnectRecord)originalRecord).value();
        Schema updatedSchema = this.schemaUpdateCache.computeIfAbsent(value.schema(), s -> this.makeUpdatedSchema(additionalFields, value.schema(), originalRecordValue));
        Struct updatedValue = new Struct(updatedSchema);
        for (com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field field : value.schema().fields()) {
            updatedValue.put(field.name(), value.getWithoutDefault(field.name()));
        }
        for (FieldReference fieldReference : additionalFields) {
            updatedValue = this.updateValue(fieldReference, updatedValue, originalRecordValue);
        }
        return ((ConnectRecord)unwrappedRecord).newRecord(((ConnectRecord)unwrappedRecord).topic(), ((ConnectRecord)unwrappedRecord).kafkaPartition(), ((ConnectRecord)unwrappedRecord).keySchema(), ((ConnectRecord)unwrappedRecord).key(), updatedSchema, updatedValue, ((ConnectRecord)unwrappedRecord).timestamp());
    }

    private Schema makeUpdatedSchema(List<FieldReference> additionalFields, Schema schema, Struct originalRecordValue) {
        SchemaBuilder builder = SchemaUtil.copySchemaBasics(schema, SchemaBuilder.struct());
        for (com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field field : schema.fields()) {
            builder.field(field.name(), field.schema());
        }
        for (FieldReference fieldReference : additionalFields) {
            builder = this.updateSchema(fieldReference, builder, originalRecordValue.schema());
        }
        return builder.build();
    }

    private SchemaBuilder updateSchema(FieldReference fieldReference, SchemaBuilder builder, Schema originalRecordSchema) {
        return builder.field(fieldReference.getNewField(), fieldReference.getSchema(originalRecordSchema));
    }

    private Struct updateValue(FieldReference fieldReference, Struct updatedValue, Struct struct) {
        return updatedValue.put(fieldReference.getNewField(), fieldReference.getValue(struct));
    }

    @Override
    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES, ExtractNewRecordStateConfigDefinition.HANDLE_DELETES, ExtractNewRecordStateConfigDefinition.ADD_FIELDS, ExtractNewRecordStateConfigDefinition.ADD_HEADERS, ExtractNewRecordStateConfigDefinition.ROUTE_BY_FIELD);
        return config;
    }

    @Override
    public void close() {
        this.beforeDelegate.close();
        this.afterDelegate.close();
        this.removedDelegate.close();
        this.updatedDelegate.close();
    }

    private static class FieldReference {
        private final String struct;
        private final String field;
        private final String newField;

        private FieldReference(String prefix, String field) {
            String[] parts = NEW_FIELD_SEPARATOR.split(field);
            String[] splits = FIELD_SEPARATOR.split(parts[0]);
            this.field = splits.length == 1 ? splits[0] : splits[1];
            String string = this.struct = splits.length == 1 ? FieldReference.determineStruct(this.field) : splits[0];
            if (parts.length == 1) {
                this.newField = prefix + (splits.length == 1 ? this.field : this.struct + "_" + this.field);
            } else if (parts.length == 2) {
                this.newField = prefix + parts[1];
            } else {
                throw new IllegalArgumentException("Unexpected field name: " + field);
            }
        }

        private static String determineStruct(String simpleFieldName) {
            if (simpleFieldName.equals("op") || simpleFieldName.equals("ts_ms")) {
                return null;
            }
            if (simpleFieldName.equals("id") || simpleFieldName.equals("data_collection_order") || simpleFieldName.equals("total_order")) {
                return "transaction";
            }
            return "source";
        }

        static List<FieldReference> fromConfiguration(String fieldPrefix, String addHeadersConfig) {
            if (Strings.isNullOrEmpty(addHeadersConfig)) {
                return Collections.emptyList();
            }
            return Arrays.stream(addHeadersConfig.split(",")).map(String::trim).map(field -> new FieldReference(fieldPrefix, (String)field)).collect(Collectors.toList());
        }

        public String getNewField() {
            return this.newField;
        }

        Object getValue(Struct originalRecordValue) {
            Struct parentStruct = this.struct != null ? (Struct)originalRecordValue.getWithoutDefault(this.struct) : originalRecordValue;
            return parentStruct != null ? parentStruct.getWithoutDefault(this.field) : null;
        }

        Schema getSchema(Schema originalRecordSchema) {
            Schema parentSchema = this.struct != null ? originalRecordSchema.field(this.struct).schema() : originalRecordSchema;
            com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field schemaField = parentSchema.field(this.field);
            if (schemaField == null) {
                throw new IllegalArgumentException("Unexpected field name: " + this.field);
            }
            return SchemaUtil.copySchemaBasics(schemaField.schema()).optional().build();
        }
    }
}

