/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.connectors.mysql.table.sink;

import com.alibaba.ververica.connectors.common.MetricUtils;
import com.alibaba.ververica.connectors.common.errorcode.ConnectorErrors;
import com.alibaba.ververica.connectors.common.exception.ConnectorException;
import com.alibaba.ververica.connectors.common.exception.ErrorUtils;
import com.alibaba.ververica.connectors.common.metrics.SimpleGauge;
import com.alibaba.ververica.connectors.common.sink.HasRetryTimeout;
import com.alibaba.ververica.connectors.common.sink.Syncable;
import com.alibaba.ververica.connectors.common.source.resolver.DirtyDataStrategy;
import com.alibaba.ververica.connectors.common.util.ConnectionPool;
import com.alibaba.ververica.connectors.common.util.StringUtils;
import com.alibaba.ververica.connectors.jdbc.util.JdbcRowConverter;
import com.alibaba.ververica.connectors.jdbc.util.SQLExceptionSkipPolicy;
import com.alibaba.ververica.connectors.jdbc.util.StringFormatRowConverter;
import com.alibaba.ververica.connectors.jdbc.util.TableSchemaCache;
import com.alibaba.ververica.connectors.jdbc.util.TpsLimitUtils;
import com.ververica.cdc.connectors.shaded.com.zaxxer.hikari.HikariDataSource;
import com.ververica.connectors.mysql.table.DataSourceOptions;
import com.ververica.connectors.mysql.table.MySqlOptions;
import com.ververica.connectors.mysql.utils.MySqlUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.BiFunction;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.shaded.guava30.com.google.common.base.Joiner;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlOutputFormat
extends RichOutputFormat<RowData>
implements Syncable,
HasRetryTimeout {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlOutputFormat.class);
    private static final String CREATE_TABLE_SQL_TPL = "CREATE TABLE IF NOT EXISTS %s (%s)";
    private final String url;
    private final String tableName;
    private final String userName;
    private final String password;
    private final DataSourceOptions dataSourceOptions;
    private final InternalJdbcConnectionOptions jdbcConnectorOptions;
    private final TableSchemaCache tableSchemaCache;
    private final int maxRetryTimes;
    private transient Timer flusher;
    private volatile long lastFlushTime = 0L;
    private final int batchSize;
    private final int bufferSize;
    private List<String> exceptUpdateKeys;
    private final long flushIntervalMs;
    private long currentCount = 0L;
    private final long maxSinkTps;
    private int numTasks = 1;
    private Meter outTps;
    private Meter outBps;
    private Counter sinkSkipCounter;
    private SimpleGauge latencyGauge;
    private Counter deleteCounter;
    private final Map<RowData, RowData> mapReduceBuffer = new HashMap<RowData, RowData>();
    private transient HikariDataSource dataSource = null;
    private static final ConnectionPool<HikariDataSource> DATA_SOURCE_POOL = new ConnectionPool();
    private String dataSourceKey = "";
    private final DirtyDataStrategy dirtyDataStrategy;
    private final boolean ignoreDelete;
    private volatile transient Exception flushException = null;
    private volatile boolean flushError = false;
    private volatile boolean isClosed = false;
    private static final long MAX_RETRY_SLEEP_TIME = 5000L;
    private final RowDataSerializer rowDataSerializer;
    private final JdbcRowConverter jdbcRowConverter;
    private JdbcRowConverter keyedJdbcRowConverter = null;

    public MySqlOutputFormat(TableSchema tableSchema, int maxRetryTimes, DirtyDataStrategy dirtyDataStrategy, int batchSize, int bufferSize, long flushIntervalMs, List<String> exceptUpdateKeys, long maxSinkTps, boolean ignoreDelete, DataSourceOptions dataSourceOptions, InternalJdbcConnectionOptions jdbcConnectorOptions) {
        this.url = jdbcConnectorOptions.getDbURL();
        this.tableName = jdbcConnectorOptions.getTableName();
        this.userName = jdbcConnectorOptions.getUsername().get();
        this.password = jdbcConnectorOptions.getPassword().get();
        this.maxRetryTimes = maxRetryTimes;
        this.dirtyDataStrategy = dirtyDataStrategy;
        this.batchSize = batchSize;
        this.bufferSize = bufferSize;
        this.flushIntervalMs = flushIntervalMs;
        this.exceptUpdateKeys = exceptUpdateKeys;
        this.maxSinkTps = maxSinkTps;
        this.ignoreDelete = ignoreDelete;
        this.dataSourceOptions = dataSourceOptions;
        this.jdbcConnectorOptions = jdbcConnectorOptions;
        this.tableSchemaCache = new TableSchemaCache(tableSchema);
        this.rowDataSerializer = new RowDataSerializer((LogicalType[])Arrays.stream(this.tableSchemaCache.getFieldDataTypes()).map(DataType::getLogicalType).toArray(LogicalType[]::new));
        this.jdbcRowConverter = new JdbcRowConverter(this.tableSchemaCache.getFieldDataTypes());
        if (this.existsPrimaryKeys()) {
            this.keyedJdbcRowConverter = new JdbcRowConverter(this.tableSchemaCache.getPrimaryKeyFieldDataTypes());
            for (String pk : (List)Preconditions.checkNotNull(this.tableSchemaCache.getPkFields())) {
                if (this.exceptUpdateKeys.contains(pk)) continue;
                this.exceptUpdateKeys.add(pk);
            }
        }
    }

    protected void scheduleFlusher() {
        this.flusher = new Timer("MySqlOutputFormat.buffer.flusher");
        this.flusher.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (System.currentTimeMillis() - MySqlOutputFormat.this.lastFlushTime >= MySqlOutputFormat.this.flushIntervalMs) {
                        MySqlOutputFormat.this.sync();
                    }
                }
                catch (Exception e) {
                    LOG.error("flush buffer to MySql failed", e);
                    MySqlOutputFormat.this.flushException = e;
                    MySqlOutputFormat.this.flushError = true;
                }
            }
        }, this.flushIntervalMs, this.flushIntervalMs);
    }

    @Override
    public long getRetryTimeout() {
        return 0L;
    }

    public void configure(Configuration configuration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(int taskNumber, int numTasks) throws IOException {
        LOG.info("MySql output format using url=" + this.url + ", tableName=" + this.tableName + ", maxRetryTimes=" + this.maxRetryTimes + ", bufferSize=" + this.bufferSize + ", batchSize=" + this.batchSize + ", flushIntervalMs=" + this.flushIntervalMs + ", excludeUpdateColumns=" + this.exceptUpdateKeys + ", ignoreDelete=" + this.ignoreDelete + ", dirtyDataStrategy=" + (Object)((Object)this.dirtyDataStrategy) + ", maxSinkTps=" + this.maxSinkTps);
        this.numTasks = numTasks;
        Class<MySqlOutputFormat> clazz = MySqlOutputFormat.class;
        synchronized (MySqlOutputFormat.class) {
            if (this.isClosed) {
                throw new RuntimeException("MySqlOutputFormat has been closed!");
            }
            this.dataSourceKey = this.url + this.userName + this.password + this.tableName;
            if (DATA_SOURCE_POOL.contains(this.dataSourceKey)) {
                this.dataSource = DATA_SOURCE_POOL.get(this.dataSourceKey);
            } else {
                this.dataSource = MySqlOptions.buildDataSourceFromOptions(this.dataSourceOptions, this.jdbcConnectorOptions);
                DATA_SOURCE_POOL.put(this.dataSourceKey, this.dataSource);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (this.existsPrimaryKeys()) {
                this.scheduleFlusher();
            }
            this.outTps = MetricUtils.registerNumRecordsOutRate(this.getRuntimeContext());
            this.outBps = MetricUtils.registerNumBytesOutRate(this.getRuntimeContext(), "MySQL");
            this.latencyGauge = MetricUtils.registerCurrentSendTime(this.getRuntimeContext());
            this.sinkSkipCounter = MetricUtils.registerNumRecordsOutErrors(this.getRuntimeContext());
            this.deleteCounter = MetricUtils.registerSinkDeleteCounter(this.getRuntimeContext());
            return;
        }
    }

    boolean existsPrimaryKeys() {
        return this.tableSchemaCache.getPkFields() != null && !this.tableSchemaCache.getPkFields().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRecord(RowData rowData) throws IOException {
        if (this.flushError && null != this.flushException) {
            throw new RuntimeException(this.flushException);
        }
        if ((rowData.getRowKind() == RowKind.DELETE || rowData.getRowKind() == RowKind.UPDATE_BEFORE) && this.ignoreDelete) {
            return;
        }
        boolean flush = false;
        if (this.existsPrimaryKeys()) {
            RowData dupKey = this.tableSchemaCache.getPrimaryKey(rowData);
            Map<RowData, RowData> map = this.mapReduceBuffer;
            synchronized (map) {
                this.mapReduceBuffer.put(dupKey, this.rowDataSerializer.copy(rowData));
                ++this.currentCount;
                flush = this.currentCount >= (long)this.bufferSize;
            }
            if (flush) {
                this.sync();
            }
        } else if (rowData.getRowKind() == RowKind.INSERT) {
            this.eagerAdd(rowData);
        } else if (rowData.getRowKind() == RowKind.DELETE) {
            this.eagerDelete(rowData);
        } else {
            throw new UnsupportedOperationException("Only INSERT and DELETE record are supported if keys are not defined");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sync() throws IOException {
        if (!this.existsPrimaryKeys()) {
            return;
        }
        Map<RowData, RowData> map = this.mapReduceBuffer;
        synchronized (map) {
            ArrayList<RowData> addBuffer = new ArrayList<RowData>();
            ArrayList<RowData> deleteBuffer = new ArrayList<RowData>();
            block7: for (Map.Entry<RowData, RowData> entry : this.mapReduceBuffer.entrySet()) {
                switch (entry.getValue().getRowKind()) {
                    case INSERT: 
                    case UPDATE_AFTER: {
                        addBuffer.add(entry.getValue());
                        continue block7;
                    }
                    case DELETE: 
                    case UPDATE_BEFORE: {
                        deleteBuffer.add(entry.getKey());
                        continue block7;
                    }
                }
                throw new RuntimeException("Not supported row kind " + entry.getValue().getRowKind());
            }
            this.batchDelete(deleteBuffer);
            this.batchAdd(addBuffer);
            this.mapReduceBuffer.clear();
            this.currentCount = 0L;
        }
        this.lastFlushTime = System.currentTimeMillis();
    }

    private void eagerAdd(RowData rowData) {
        String insertSql = com.alibaba.ververica.connectors.jdbc.util.MySqlUtils.getInsertSql(this.tableSchemaCache.getFieldNames(), this.tableName);
        this.executeSql(insertSql, Collections.singletonList(rowData), this.jdbcRowConverter, (sql, prepareStatement) -> ConnectorErrors.INST.rdsWriteError("MySql", (String)sql));
    }

    private void eagerDelete(RowData rowData) {
        HashSet<Integer> nullFieldsIndex = new HashSet<Integer>();
        for (int i = 0; i < rowData.getArity(); ++i) {
            if (!rowData.isNullAt(i)) continue;
            nullFieldsIndex.add(i);
        }
        String eagerDeleteSql = com.alibaba.ververica.connectors.jdbc.util.MySqlUtils.getDeleteSql(Arrays.asList(this.tableSchemaCache.getFieldNames()), this.tableName, nullFieldsIndex);
        if (nullFieldsIndex.size() > 0) {
            DataType[] types = new DataType[rowData.getArity() - nullFieldsIndex.size()];
            GenericRowData param = new GenericRowData(rowData.getArity() - nullFieldsIndex.size());
            int j = 0;
            for (int i = 0; i < rowData.getArity(); ++i) {
                if (nullFieldsIndex.contains(i)) continue;
                types[j] = this.tableSchemaCache.getFieldDataTypes()[i];
                param.setField(j, this.tableSchemaCache.getFieldGetters()[i].getFieldOrNull(rowData));
                ++j;
            }
            JdbcRowConverter converter = new JdbcRowConverter(types);
            this.executeSql(eagerDeleteSql, Collections.singletonList(param), converter, (sql, prepareStatement) -> ConnectorErrors.INST.rdsWriteError("MySql", (String)sql));
        } else {
            this.executeSql(eagerDeleteSql, Collections.singletonList(rowData), this.jdbcRowConverter, (sql, prepareStatement) -> ConnectorErrors.INST.rdsWriteError("MySql", (String)sql));
        }
        this.deleteCounter.inc();
    }

    private void batchDelete(List<RowData> writeDelBatch) {
        LOG.info("BatchDeleteSize [{}]", (Object)writeDelBatch.size());
        String deleteSql = com.alibaba.ververica.connectors.jdbc.util.MySqlUtils.getDeleteSql((List)Preconditions.checkNotNull(this.tableSchemaCache.getPkFields()), this.tableName, Collections.emptySet());
        this.batchExecute(deleteSql, writeDelBatch, this.keyedJdbcRowConverter, (sql, prepareStatement) -> ConnectorErrors.INST.rdsBatchDeleteError("MySql", (String)sql, String.valueOf(prepareStatement)));
        this.deleteCounter.inc((long)writeDelBatch.size());
    }

    private void batchAdd(List<RowData> writeAddBatch) {
        LOG.info("BatchUpdateSize [{}]", (Object)writeAddBatch.size());
        String updateSql = com.alibaba.ververica.connectors.jdbc.util.MySqlUtils.getDuplicateUpdateSql(this.tableSchemaCache.getFieldNames(), this.tableSchemaCache.getPkFields(), this.exceptUpdateKeys, this.tableName);
        this.batchExecute(updateSql, writeAddBatch, this.jdbcRowConverter, (sql, prepareStatement) -> ConnectorErrors.INST.rdsBatchWriteError("MySql", (String)sql, String.valueOf(prepareStatement)));
    }

    private void batchExecute(String sql, List<RowData> buffers, JdbcRowConverter rowDataConverter, BiFunction<String, PreparedStatement, String> errorMessageGenerator) {
        ArrayList<RowData> batchBuffer = new ArrayList<RowData>();
        for (RowData row : buffers) {
            batchBuffer.add(row);
            if (batchBuffer.size() < this.batchSize) continue;
            this.executeSql(sql, batchBuffer, rowDataConverter, errorMessageGenerator);
            batchBuffer.clear();
        }
        if (batchBuffer.size() > 0) {
            this.executeSql(sql, batchBuffer, rowDataConverter, errorMessageGenerator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(String sql, List<RowData> rowDataList, JdbcRowConverter rowDataConverter, BiFunction<String, PreparedStatement, String> errorMessageGenerator) {
        if (rowDataList == null || rowDataList.isEmpty()) {
            return;
        }
        int count = rowDataList.size();
        int retriedTimes = 0;
        while (!rowDataList.isEmpty() && retriedTimes++ < this.maxRetryTimes) {
            if (this.isClosed) {
                throw new RuntimeException("MySqlOutputFormat has been closed!");
            }
            long start = System.currentTimeMillis();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            int sinkCount = 0;
            try {
                connection = this.dataSource.getConnection();
                connection.setAutoCommit(false);
                preparedStatement = connection.prepareStatement(sql);
                for (RowData row : rowDataList) {
                    rowDataConverter.toExternal(row, preparedStatement);
                    preparedStatement.addBatch();
                    ++sinkCount;
                }
                long startTime = System.currentTimeMillis();
                preparedStatement.executeBatch();
                connection.commit();
                if (this.latencyGauge != null) {
                    this.latencyGauge.report(System.currentTimeMillis() - startTime, count);
                }
                if (this.outTps != null) {
                    this.outTps.markEvent((long)count);
                }
                if (this.outBps != null) {
                    this.outBps.markEvent((long)(count * 1000));
                }
                TpsLimitUtils.limitTps(this.maxSinkTps, this.numTasks, start, sinkCount);
                this.lastFlushTime = System.currentTimeMillis();
            }
            catch (SQLException exception) {
                try {
                    LOG.error("Execute sql error, retry times=" + retriedTimes, exception);
                    RowData firstRow = rowDataList.get(0);
                    StringFormatRowConverter stringConverter = new StringFormatRowConverter(rowDataConverter.getFieldLogicalTypes(), null);
                    String fieldValues = StringUtils.join(stringConverter.convertToString(firstRow), ",");
                    LOG.error("Execute sql is " + sql + " , first row is [ " + fieldValues + " ]");
                    if (connection != null) {
                        try {
                            LOG.warn("Transaction is being rolled back");
                            connection.rollback();
                        }
                        catch (Exception ex) {
                            LOG.warn("Rollback failed", ex);
                        }
                    }
                    if (retriedTimes >= this.maxRetryTimes) {
                        ConnectorException connectorException = ErrorUtils.getException(errorMessageGenerator.apply(sql, preparedStatement), exception);
                        if (SQLExceptionSkipPolicy.judge(this.dirtyDataStrategy, exception.getErrorCode(), connectorException)) {
                            this.sinkSkipCounter.inc((long)count);
                            LOG.error(connectorException.getErrorMessage() + " sql:" + sql);
                        }
                    }
                    try {
                        if (!this.isClosed && retriedTimes < this.maxRetryTimes) {
                            Thread.sleep(Math.min((long)(1000 * retriedTimes), 5000L));
                        }
                    }
                    catch (Exception e1) {
                        LOG.error("Thread sleep exception in MySqlOutputFormat class", e1);
                    }
                }
                catch (Throwable throwable) {
                    MySqlUtils.closeMysqlStatement(preparedStatement);
                    MySqlUtils.closeMysqlConnection(connection);
                    throw throwable;
                }
                MySqlUtils.closeMysqlStatement(preparedStatement);
                MySqlUtils.closeMysqlConnection(connection);
                continue;
            }
            MySqlUtils.closeMysqlStatement(preparedStatement);
            MySqlUtils.closeMysqlConnection(connection);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.flusher != null) {
            this.flusher.cancel();
            this.flusher = null;
        }
        this.sync();
        Class<MySqlOutputFormat> clazz = MySqlOutputFormat.class;
        synchronized (MySqlOutputFormat.class) {
            this.isClosed = true;
            if (this.dataSourceKey != null && DATA_SOURCE_POOL.remove(this.dataSourceKey)) {
                this.dataSource.close();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LOG.info("Close data source.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(int varcharMaxLength) throws Exception {
        String sql = this.getCreateTableSql(varcharMaxLength);
        HikariDataSource source = MySqlOptions.buildDataSourceFromOptions(this.dataSourceOptions, this.jdbcConnectorOptions);
        Connection connection = null;
        Statement statement = null;
        int retryTime = 0;
        ConnectorException connectorException = null;
        while (retryTime++ < this.maxRetryTimes) {
            try {
                connection = source.getConnection();
                statement = connection.createStatement();
                statement.execute(sql);
            }
            catch (SQLException e) {
                try {
                    LOG.error("create db error,exception:", e);
                    if (retryTime == this.maxRetryTimes) {
                        connectorException = ErrorUtils.getException(ConnectorErrors.INST.rdsCreateTableError("MySQL", sql), e);
                    }
                    try {
                        if (!this.isClosed && retryTime < this.maxRetryTimes) {
                            Thread.sleep(Math.min((long)(1000 * retryTime), 5000L));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    MySqlUtils.closeMysqlStatement(statement);
                    MySqlUtils.closeMysqlConnection(connection);
                    throw throwable;
                }
                MySqlUtils.closeMysqlStatement(statement);
                MySqlUtils.closeMysqlConnection(connection);
                continue;
            }
            MySqlUtils.closeMysqlStatement(statement);
            MySqlUtils.closeMysqlConnection(connection);
            break;
        }
        if (!source.isClosed()) {
            source.close();
        }
        if (connectorException != null) {
            throw connectorException;
        }
    }

    public String getCreateTableSql(int varcharMaxLength) {
        String[] fieldNames = this.tableSchemaCache.getFieldNames();
        LogicalType[] fieldLogicalTypes = (LogicalType[])Arrays.stream(this.tableSchemaCache.getFieldDataTypes()).map(DataType::getLogicalType).toArray(LogicalType[]::new);
        List<String> pkFields = this.tableSchemaCache.getPkFields();
        int fieldsNum = fieldNames.length;
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < fieldsNum; ++i) {
            String fieldName = fieldNames[i];
            LogicalType type = fieldLogicalTypes[i];
            resultList.add(fieldName + " " + this.getMySqlType(type, varcharMaxLength));
        }
        Joiner joinerOnComma = Joiner.on(",");
        if (pkFields != null && !pkFields.isEmpty()) {
            String pkString = String.format("PRIMARY KEY(%s)", joinerOnComma.join(pkFields));
            resultList.add(pkString);
        }
        return String.format(CREATE_TABLE_SQL_TPL, this.tableName, joinerOnComma.join(resultList));
    }

    public String getMySqlType(LogicalType type, int varcharMaxLength) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return "INT";
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return "BIGINT";
            }
            case FLOAT: {
                return "FLOAT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case DECIMAL: {
                return "DECIMAL";
            }
            case CHAR: 
            case VARCHAR: {
                return String.format("VARCHAR(%d)", varcharMaxLength);
            }
            case BINARY: 
            case VARBINARY: {
                return "VARBINARY";
            }
            case DATE: {
                return "DATE";
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return "TIME";
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return "TIMESTAMP";
            }
        }
        throw new IllegalArgumentException("Unsupported sql column type " + type + " !");
    }
}

