/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.connectors.mysql.table;

import java.io.Serializable;
import java.util.Objects;

public class DataSourceOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int connectionMaxSize;
    private final long connectionTimeout;
    private final int connectionMinIdle;

    private DataSourceOptions(int connectionMaxSize, long connectionTimeout, int connectionMinIdle) {
        this.connectionMaxSize = connectionMaxSize;
        this.connectionTimeout = connectionTimeout;
        this.connectionMinIdle = connectionMinIdle;
    }

    public int getConnectionMaxSize() {
        return this.connectionMaxSize;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getConnectionMinIdle() {
        return this.connectionMinIdle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataSourceOptions)) {
            return false;
        }
        DataSourceOptions that = (DataSourceOptions)o;
        return this.connectionMaxSize == that.connectionMaxSize && this.connectionTimeout == that.connectionTimeout && this.connectionMinIdle == that.connectionMinIdle;
    }

    public int hashCode() {
        return Objects.hash(this.connectionMaxSize, this.connectionTimeout, this.connectionMinIdle);
    }

    public static class Builder {
        private int connectionMaxSize;
        private long connectionTimeout;
        private int connectionMinIdle;

        public Builder withConnectionMaxSize(int connectionMaxSize) {
            this.connectionMaxSize = connectionMaxSize;
            return this;
        }

        public Builder withConnectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder withConnectionMinIdle(int connectionMinIdle) {
            this.connectionMinIdle = connectionMinIdle;
            return this;
        }

        public DataSourceOptions build() {
            return new DataSourceOptions(this.connectionMaxSize, this.connectionTimeout, this.connectionMinIdle);
        }
    }
}

