/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.connectors.mysql.catalog;

import com.ververica.cdc.connectors.mysql.schema.MySqlTableDefinition;
import com.ververica.cdc.connectors.mysql.schema.MySqlTypeUtils;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceOptions;
import com.ververica.cdc.connectors.mysql.table.MySqlReadableMetadata;
import com.ververica.cdc.connectors.mysql.table.MySqlReadableSystemColumn;
import com.ververica.connectors.mysql.catalog.CatalogThreadPool;
import com.ververica.connectors.mysql.catalog.cache.MysqlCatalogCacheHolder;
import com.ververica.connectors.mysql.connection.MySqlConnectionProvider;
import com.ververica.connectors.mysql.table.MySqlDynamicTableFactory;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.text.ParsingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlCatalog
extends AbstractJdbcCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlCatalog.class);
    public static final String MYSQL_CATALOG_THREAD_POOL_NAME = "MysqlCatalogThreadPool";
    private static final Set<String> builtinDatabases = new HashSet<String>(){
        {
            this.add("information_schema");
            this.add("performance_schema");
            this.add("mysql");
            this.add("sys");
        }
    };
    private MySqlConnectionProvider jdbcConnectionProvider;
    private final String hostname;
    private final Integer port;
    private final MysqlCatalogCacheHolder cacheHolder;
    private MySqlAntlrDdlParser mySqlAntlrDdlParser = null;
    private final int connectPoolSize;
    private final int connectMaxRetries;
    private final Duration connectTimeOut;
    private final int threadPoolSize;
    private CatalogThreadPool threadPool;
    private final Properties jdbcProperties;
    private final List<String> metadataColumns;
    private final boolean treatTinyint1AsBool;

    public MySqlCatalog(String catalogName, String defaultDatabase, String hostname, Integer port, String username, String password, Duration cacheTtl, int connectPoolSize, int connectMaxRetries, Duration connectTimeOut, int threadPoolSize, Properties jdbcProperties, List<String> metadataColumns, boolean treatTinyint1AsBool) {
        super(Thread.currentThread().getContextClassLoader(), catalogName, defaultDatabase, username, password, String.format("jdbc:mysql://%s:%s", hostname, port));
        this.hostname = hostname;
        this.port = port;
        this.cacheHolder = new MysqlCatalogCacheHolder(cacheTtl);
        this.connectPoolSize = connectPoolSize;
        this.connectMaxRetries = connectMaxRetries;
        this.connectTimeOut = connectTimeOut;
        this.threadPoolSize = threadPoolSize;
        this.jdbcProperties = jdbcProperties;
        this.metadataColumns = metadataColumns;
        this.treatTinyint1AsBool = treatTinyint1AsBool;
    }

    @Override
    public void open() throws CatalogException {
        this.jdbcConnectionProvider = new MySqlConnectionProvider(this.hostname, this.port.intValue(), this.username, this.pwd, this.connectPoolSize, this.connectMaxRetries, this.connectTimeOut, this.jdbcProperties);
        try {
            this.jdbcConnectionProvider.connect();
        }
        catch (SQLException e) {
            throw new CatalogException("Failed to connect to mysql server.", (Throwable)e);
        }
        LOG.info("Catalog {} established connection to {}", (Object)this.getName(), (Object)this.defaultUrl);
    }

    @Override
    public void close() {
        super.close();
        if (this.jdbcConnectionProvider != null) {
            this.jdbcConnectionProvider.close();
        }
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
        ResourceBundle.clearCache(MySqlCatalog.class.getClassLoader());
    }

    @Override
    public Optional<Factory> getFactory() {
        return Optional.of(new MySqlDynamicTableFactory());
    }

    public List<String> listDatabases() throws CatalogException {
        List<String> list;
        block8: {
            Connection conn = this.jdbcConnectionProvider.connect();
            try {
                list = this.listDatabases(conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CatalogException(String.format("Failed listing database in %s catalog ", this.getName()), (Throwable)e);
                }
            }
            conn.close();
        }
        return list;
    }

    @Override
    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        if (this.listDatabases().contains(databaseName)) {
            return new CatalogDatabaseImpl(Collections.emptyMap(), null);
        }
        throw new DatabaseNotExistException(this.getName(), databaseName);
    }

    @Override
    public boolean databaseExists(String databaseName) throws CatalogException {
        boolean bl;
        block8: {
            Connection conn = this.jdbcConnectionProvider.connect();
            try {
                bl = this.databaseExists(conn, databaseName);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CatalogException(String.format("Fail to get database %s", databaseName), (Throwable)e);
                }
            }
            conn.close();
        }
        return bl;
    }

    private List<String> matchedDatabases(Connection conn, String databaseName) {
        List<String> databases = this.listDatabases(conn);
        if (databases.contains(databaseName)) {
            return Collections.singletonList(databaseName);
        }
        Pattern pattern = Pattern.compile(databaseName);
        ArrayList<String> matched = new ArrayList<String>();
        for (String dbName : databases) {
            if (!pattern.matcher(dbName).matches()) continue;
            matched.add(dbName);
        }
        return matched;
    }

    public List<String> listTables(String databaseName) throws CatalogException {
        List<String> list;
        block8: {
            Connection conn = this.jdbcConnectionProvider.connect();
            try {
                list = this.listTables(conn, databaseName);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CatalogException(String.format("Failed listing tables in database %s", databaseName), (Throwable)e);
                }
            }
            conn.close();
        }
        return list;
    }

    @Override
    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        CatalogTable catalogTable;
        block20: {
            Connection conn = this.jdbcConnectionProvider.connect();
            try {
                List<ObjectPath> matchedTables = this.matchedTables(conn, tablePath);
                if (matchedTables.isEmpty()) {
                    throw new TableNotExistException(this.getName(), tablePath);
                }
                LOG.info("Matched Tables for table path {}: {}", (Object)tablePath, (Object)matchedTables);
                LinkedHashMap<String, DataType> columns = new LinkedHashMap<String, DataType>();
                ArrayList<String> pks = new ArrayList<String>();
                Map<String, String> tableProperties = this.getTableProperties(tablePath);
                if (matchedTables.size() > 1) {
                    tableProperties.put(MySqlSourceOptions.INTERNAL_IS_SHARDING_TABLE.key(), "true");
                    for (MySqlReadableSystemColumn systemData : MySqlReadableSystemColumn.values()) {
                        columns.put(systemData.getKey(), systemData.getDataType());
                        pks.add(systemData.getKey());
                    }
                }
                boolean firstTable = true;
                List beforePKs = Collections.emptyList();
                Map<ObjectPath, Future<Schema>> futures = this.asyncGetSchema(matchedTables);
                for (ObjectPath matchedTablePath : matchedTables) {
                    try {
                        Schema schema = this.getTableSchema(matchedTablePath, futures, conn);
                        for (Schema.UnresolvedColumn column : schema.getColumns()) {
                            DataType columnType = (DataType)((Schema.UnresolvedPhysicalColumn)column).getDataType();
                            if (columns.containsKey(column.getName()) && !columnType.getLogicalType().getTypeRoot().equals((Object)((DataType)columns.get(column.getName())).getLogicalType().getTypeRoot())) {
                                throw new TableException(String.format("Meet inconsistent type: column %s whose type is %s in %s but exists one table that whose type is %s.", column.getName(), columnType, matchedTablePath, columns.get(column.getName())));
                            }
                            columns.put(column.getName(), columnType);
                        }
                        List currentPKs = schema.getPrimaryKey().map(Schema.UnresolvedPrimaryKey::getColumnNames).orElseGet(ArrayList::new);
                        if (firstTable) {
                            beforePKs = currentPKs;
                            firstTable = false;
                            continue;
                        }
                        if (beforePKs.equals(currentPKs)) continue;
                        throw new TableException(String.format("Meet inconsistent PK constraints: the primary keys in the table %s are %s but exists table whose primary keys are %s.", matchedTablePath, currentPKs, beforePKs));
                    }
                    catch (Exception e) {
                        throw new CatalogException(String.format("Failed getting table `%s`.`%s`.", tablePath.getDatabaseName(), tablePath.getObjectName()), (Throwable)e);
                    }
                }
                Schema.Builder builder = Schema.newBuilder().fromFields(columns.keySet().toArray(new String[0]), columns.values().toArray(new AbstractDataType[0]));
                if (!this.metadataColumns.isEmpty()) {
                    for (String metadataColumn : this.metadataColumns) {
                        if (matchedTables.size() > 1 && (MySqlReadableMetadata.TABLE_NAME.getKey().equals(metadataColumn) || MySqlReadableMetadata.DATABASE_NAME.getKey().equals(metadataColumn))) continue;
                        builder.columnByMetadata(metadataColumn, (AbstractDataType)Arrays.stream(MySqlReadableMetadata.values()).filter(m -> m.getKey().equals(metadataColumn)).findFirst().get().getDataType(), true);
                    }
                }
                pks.addAll(beforePKs);
                if (!pks.isEmpty()) {
                    builder.primaryKey(pks.toArray(new String[0]));
                }
                catalogTable = CatalogTable.of((Schema)builder.build(), null, Collections.emptyList(), tableProperties);
                if (conn == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CatalogException(String.format("Fail to get table %s.", tablePath.getFullName()), (Throwable)e);
                }
            }
            conn.close();
        }
        return catalogTable;
    }

    private Map<ObjectPath, Future<Schema>> asyncGetSchema(List<ObjectPath> matchedTables) {
        HashMap<ObjectPath, Future<Schema>> futures = new HashMap<ObjectPath, Future<Schema>>();
        for (ObjectPath matchedTablePath : matchedTables) {
            if (this.cacheHolder.schemaAvailable(matchedTablePath)) continue;
            futures.put(matchedTablePath, this.getThreadPool().submit(() -> this.getSchema(matchedTablePath)));
        }
        return futures;
    }

    private Schema getTableSchema(ObjectPath tablePath, Map<ObjectPath, Future<Schema>> futures, Connection conn) {
        if (futures.get(tablePath) != null) {
            return this.cacheHolder.getTableSchema(tablePath, () -> {
                try {
                    return (Schema)((Future)futures.get(tablePath)).get();
                }
                catch (Exception e) {
                    throw new IllegalStateException(String.format("Fail to get table schema of table %s.", tablePath.getFullName()), e);
                }
            });
        }
        return this.cacheHolder.getTableSchema(tablePath, () -> this.getSchema(conn, tablePath));
    }

    private synchronized Table parseDdl(String ddlStatement, ObjectPath tablePath) {
        MySqlAntlrDdlParser mySqlAntlrDdlParser = this.getParser();
        mySqlAntlrDdlParser.setCurrentDatabase(tablePath.getDatabaseName());
        Tables tables = new Tables();
        mySqlAntlrDdlParser.parse(ddlStatement, tables);
        return tables.forTable(tablePath.getDatabaseName(), null, tablePath.getObjectName());
    }

    private synchronized MySqlAntlrDdlParser getParser() {
        if (this.mySqlAntlrDdlParser == null) {
            this.mySqlAntlrDdlParser = new MySqlAntlrDdlParser();
        }
        return this.mySqlAntlrDdlParser;
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        boolean bl;
        block8: {
            Connection conn = this.jdbcConnectionProvider.connect();
            try {
                boolean bl2 = bl = !this.matchedTables(conn, tablePath).isEmpty();
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CatalogException(String.format("Fail to get table %s", tablePath.getFullName()), (Throwable)e);
                }
            }
            conn.close();
        }
        return bl;
    }

    private List<ObjectPath> matchedTables(Connection conn, ObjectPath tablePath) {
        List<String> matchedDatabases = this.matchedDatabases(conn, tablePath.getDatabaseName());
        ArrayList<ObjectPath> matchedTables = new ArrayList<ObjectPath>();
        String tableName = tablePath.getObjectName();
        Pattern tablePattern = Pattern.compile(tableName);
        for (String database : matchedDatabases) {
            List<String> tables = this.listTables(conn, database);
            if (tables.contains(tableName)) {
                matchedTables.add(new ObjectPath(database, tableName));
                continue;
            }
            matchedTables.addAll(tables.stream().filter(table -> tablePattern.matcher((CharSequence)table).matches()).map(table -> new ObjectPath(database, table)).collect(Collectors.toList()));
        }
        return matchedTables;
    }

    @VisibleForTesting
    public String getHostname() {
        return this.hostname;
    }

    @VisibleForTesting
    public Integer getPort() {
        return this.port;
    }

    private List<String> listDatabases(Connection conn) throws CatalogException {
        return this.cacheHolder.getDbs(() -> {
            try {
                ArrayList<String> databases = new ArrayList<String>();
                PreparedStatement ps = conn.prepareStatement("select schema_name from information_schema.SCHEMATA;");
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    String dbName = rs.getString(1);
                    if (builtinDatabases.contains(dbName)) continue;
                    databases.add(dbName);
                }
                return databases;
            }
            catch (Exception e) {
                throw new CatalogException(String.format("Failed listing database in %s catalog ", this.getName()), (Throwable)e);
            }
        });
    }

    private List<String> listTables(Connection conn, String databaseName) throws CatalogException {
        return this.cacheHolder.getTables(databaseName, () -> {
            try {
                if (!this.databaseExists(conn, databaseName)) {
                    throw new DatabaseNotExistException(this.getName(), databaseName);
                }
                ArrayList<String> tables = new ArrayList<String>();
                PreparedStatement ps = conn.prepareStatement(String.format("select table_name from information_schema.tables where table_schema='%s';", databaseName));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    tables.add(rs.getString(1));
                }
                return tables;
            }
            catch (Exception e) {
                throw new CatalogException(String.format("Failed listing tables in database %s", databaseName), (Throwable)e);
            }
        });
    }

    private boolean databaseExists(Connection conn, String databaseName) throws CatalogException {
        try {
            return !this.matchedDatabases(conn, databaseName).isEmpty();
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Fail to get database %s", databaseName), (Throwable)e);
        }
    }

    private Schema getSchema(ObjectPath tablePath) {
        Schema schema;
        block8: {
            Connection conn = this.jdbcConnectionProvider.connect();
            try {
                schema = this.getSchema(conn, tablePath);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException(String.format("Fail to get the table schema of table %s.", tablePath.getFullName()), e);
                }
            }
            conn.close();
        }
        return schema;
    }

    private Schema getSchema(Connection conn, ObjectPath tablePath) {
        String ddlStatement = this.showCreateTable(conn, tablePath);
        try {
            return this.parseDDL(ddlStatement, tablePath);
        }
        catch (ParsingException pe) {
            LOG.warn("Failed to parse DDL: \n{}\nWill try parsing by describing table.", (Object)ddlStatement, (Object)pe);
            ddlStatement = this.describeTable(conn, tablePath);
            return this.parseDDL(ddlStatement, tablePath);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String showCreateTable(Connection conn, ObjectPath tablePath) {
        try (PreparedStatement ps = conn.prepareStatement(String.format("SHOW CREATE TABLE `%s`.`%s`", tablePath.getDatabaseName(), tablePath.getObjectName()));){
            String string;
            block15: {
                ResultSet rs = ps.executeQuery();
                try {
                    String ddlStatement = null;
                    while (rs.next()) {
                        ddlStatement = rs.getString(2);
                    }
                    string = ddlStatement;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to show create table for %s", tablePath), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String describeTable(Connection conn, ObjectPath tablePath) {
        ArrayList<MySqlTableDefinition.MySqlFieldDefinition> fieldMetas = new ArrayList<MySqlTableDefinition.MySqlFieldDefinition>();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        try (PreparedStatement ps = conn.prepareStatement(String.format("DESC `%s`.`%s`", tablePath.getDatabaseName(), tablePath.getObjectName()));){
            String string;
            block16: {
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        MySqlTableDefinition.MySqlFieldDefinition meta = new MySqlTableDefinition.MySqlFieldDefinition();
                        meta.setColumnName(rs.getString("Field"));
                        meta.setColumnType(rs.getString("Type"));
                        meta.setNullable(StringUtils.equalsIgnoreCase((CharSequence)rs.getString("Null"), (CharSequence)"YES"));
                        meta.setKey("PRI".equalsIgnoreCase(rs.getString("Key")));
                        meta.setUnique("UNI".equalsIgnoreCase(rs.getString("Key")));
                        meta.setDefaultValue(rs.getString("Default"));
                        meta.setExtra(rs.getString("Extra"));
                        if (meta.isKey()) {
                            primaryKeys.add(meta.getColumnName());
                        }
                        fieldMetas.add(meta);
                    }
                    string = new MySqlTableDefinition(new TableId(tablePath.getDatabaseName(), null, tablePath.getObjectName()), fieldMetas, primaryKeys).toDdl();
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to describe table %s", tablePath), e);
        }
    }

    private Schema parseDDL(String ddlStatement, ObjectPath tablePath) {
        Table table = this.parseDdl(ddlStatement, tablePath);
        List<String> primaryKey = table.primaryKeyColumnNames();
        List<Column> columns = table.columns();
        String[] names = new String[columns.size()];
        DataType[] types = new DataType[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            names[i] = column.name();
            types[i] = MySqlTypeUtils.fromDbzColumn((Column)column, (boolean)this.treatTinyint1AsBool);
            if (column.isOptional()) continue;
            types[i] = (DataType)types[i].notNull();
        }
        Schema.Builder tableBuilder = Schema.newBuilder().fromFields(names, (AbstractDataType[])types);
        if (Objects.nonNull(primaryKey) && !primaryKey.isEmpty()) {
            tableBuilder.primaryKey(primaryKey);
        }
        return tableBuilder.build();
    }

    private CatalogThreadPool getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = new CatalogThreadPool(this.threadPoolSize, MYSQL_CATALOG_THREAD_POOL_NAME);
        }
        return this.threadPool;
    }

    private Map<String, String> getTableProperties(ObjectPath tablePath) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(FactoryUtil.CONNECTOR.key(), "mysql");
        props.put(MySqlSourceOptions.HOSTNAME.key(), this.hostname);
        props.put(MySqlSourceOptions.PORT.key(), String.valueOf(this.port));
        props.put(MySqlSourceOptions.DATABASE_NAME.key(), tablePath.getDatabaseName());
        props.put(MySqlSourceOptions.TABLE_NAME.key(), tablePath.getObjectName());
        props.put(MySqlSourceOptions.USERNAME.key(), this.username);
        props.put(MySqlSourceOptions.PASSWORD.key(), this.pwd);
        if (!this.treatTinyint1AsBool) {
            props.put("jdbc.properties.tinyInt1isBit", "false");
        }
        return props;
    }

    @VisibleForTesting
    Properties getJdbcProperties() {
        return this.jdbcProperties;
    }

    @VisibleForTesting
    List<String> getMetadataColumns() {
        return this.metadataColumns;
    }
}

