/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.AbstractStatus;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.ConnectorStatus;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.TaskStatus;
import java.util.Objects;

public class RestartRequest
implements Comparable<RestartRequest> {
    private final String connectorName;
    private final boolean onlyFailed;
    private final boolean includeTasks;

    public RestartRequest(String connectorName, boolean onlyFailed, boolean includeTasks) {
        this.connectorName = Objects.requireNonNull(connectorName, "Connector name may not be null");
        this.onlyFailed = onlyFailed;
        this.includeTasks = includeTasks;
    }

    public String connectorName() {
        return this.connectorName;
    }

    public boolean onlyFailed() {
        return this.onlyFailed;
    }

    public boolean includeTasks() {
        return this.includeTasks;
    }

    public boolean shouldRestartConnector(ConnectorStatus status) {
        return !this.onlyFailed || status.state() == AbstractStatus.State.FAILED;
    }

    public boolean forceRestartConnectorOnly() {
        return !this.onlyFailed() && !this.includeTasks();
    }

    public boolean shouldRestartTask(TaskStatus status) {
        return this.includeTasks && (!this.onlyFailed || status.state() == AbstractStatus.State.FAILED);
    }

    @Override
    public int compareTo(RestartRequest o) {
        int result = this.connectorName.compareTo(o.connectorName);
        return result == 0 ? this.impactRank() - o.impactRank() : result;
    }

    private int impactRank() {
        if (this.onlyFailed && !this.includeTasks) {
            return 0;
        }
        if (this.onlyFailed && this.includeTasks) {
            return 1;
        }
        if (!this.onlyFailed && !this.includeTasks) {
            return 2;
        }
        return 3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestartRequest that = (RestartRequest)o;
        return this.onlyFailed == that.onlyFailed && this.includeTasks == that.includeTasks && Objects.equals(this.connectorName, that.connectorName);
    }

    public int hashCode() {
        return Objects.hash(this.connectorName, this.onlyFailed, this.includeTasks);
    }

    public String toString() {
        return "restart request for {connectorName='" + this.connectorName + "', onlyFailed=" + this.onlyFailed + ", includeTasks=" + this.includeTasks + '}';
    }
}

