/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.expiring;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.expiring.ExpiringCredential;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.expiring.ExpiringCredentialRefreshConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.KafkaThread;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Time;
import java.util.Date;
import java.util.Objects;
import java.util.Random;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExpiringCredentialRefreshingLogin
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ExpiringCredentialRefreshingLogin.class);
    private static final long DELAY_SECONDS_BEFORE_NEXT_RETRY_WHEN_RELOGIN_FAILS = 10L;
    private static final Random RNG = new Random();
    private final Time time;
    private Thread refresherThread;
    private final LoginContextFactory loginContextFactory;
    private final String contextName;
    private final Configuration configuration;
    private final ExpiringCredentialRefreshConfig expiringCredentialRefreshConfig;
    private final AuthenticateCallbackHandler callbackHandler;
    private volatile Subject subject = null;
    private boolean hasExpiringCredential = false;
    private String principalName = null;
    private LoginContext loginContext = null;
    private ExpiringCredential expiringCredential = null;
    private final Class<?> mandatoryClassToSynchronizeOnPriorToRefresh;

    public ExpiringCredentialRefreshingLogin(String contextName, Configuration configuration, ExpiringCredentialRefreshConfig expiringCredentialRefreshConfig, AuthenticateCallbackHandler callbackHandler, Class<?> mandatoryClassToSynchronizeOnPriorToRefresh) {
        this(contextName, configuration, expiringCredentialRefreshConfig, callbackHandler, mandatoryClassToSynchronizeOnPriorToRefresh, new LoginContextFactory(), Time.SYSTEM);
    }

    public ExpiringCredentialRefreshingLogin(String contextName, Configuration configuration, ExpiringCredentialRefreshConfig expiringCredentialRefreshConfig, AuthenticateCallbackHandler callbackHandler, Class<?> mandatoryClassToSynchronizeOnPriorToRefresh, LoginContextFactory loginContextFactory, Time time) {
        this.contextName = Objects.requireNonNull(contextName);
        this.configuration = Objects.requireNonNull(configuration);
        this.expiringCredentialRefreshConfig = Objects.requireNonNull(expiringCredentialRefreshConfig);
        this.callbackHandler = callbackHandler;
        this.mandatoryClassToSynchronizeOnPriorToRefresh = Objects.requireNonNull(mandatoryClassToSynchronizeOnPriorToRefresh);
        this.loginContextFactory = loginContextFactory;
        this.time = Objects.requireNonNull(time);
    }

    public Subject subject() {
        return this.subject;
    }

    public String contextName() {
        return this.contextName;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public AuthenticateCallbackHandler callbackHandler() {
        return this.callbackHandler;
    }

    public String serviceName() {
        return "kafka";
    }

    public LoginContext login() throws LoginException {
        LoginContext tmpLoginContext = this.loginContextFactory.createLoginContext(this);
        tmpLoginContext.login();
        log.info("Successfully logged in.");
        this.loginContext = tmpLoginContext;
        this.subject = this.loginContext.getSubject();
        this.expiringCredential = this.expiringCredential();
        boolean bl = this.hasExpiringCredential = this.expiringCredential != null;
        if (!this.hasExpiringCredential) {
            log.debug("No Expiring Credential");
            this.principalName = null;
            this.refresherThread = null;
            return this.loginContext;
        }
        this.principalName = this.expiringCredential.principalName();
        long expireTimeMs = this.expiringCredential.expireTimeMs();
        long nowMs = this.currentMs();
        if (nowMs > expireTimeMs) {
            log.error("[Principal={}]: Current clock: {} is later than expiry {}. This may indicate a clock skew problem. Check that this host's and remote host's clocks are in sync. Not starting refresh thread. This process is likely unable to authenticate SASL connections (for example, it is unlikely to be able to authenticate a connection with a Kafka Broker).", this.principalLogText(), new Date(nowMs), new Date(expireTimeMs));
            return this.loginContext;
        }
        if (log.isDebugEnabled()) {
            log.debug("[Principal={}]: It is an expiring credential", (Object)this.principalLogText());
        }
        this.refresherThread = KafkaThread.daemon(String.format("kafka-expiring-relogin-thread-%s", this.principalName), new Refresher());
        this.refresherThread.start();
        this.loginContextFactory.refresherThreadStarted();
        return this.loginContext;
    }

    @Override
    public void close() {
        if (this.refresherThread != null && this.refresherThread.isAlive()) {
            this.refresherThread.interrupt();
            try {
                this.refresherThread.join();
            }
            catch (InterruptedException e) {
                log.warn("[Principal={}]: Interrupted while waiting for re-login thread to shutdown.", (Object)this.principalLogText(), (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public abstract ExpiringCredential expiringCredential();

    private Long refreshMs(long relativeToMs) {
        if (this.expiringCredential == null) {
            long retvalNextRefreshMs = relativeToMs + 10000L;
            log.warn("[Principal={}]: No Expiring credential found: will try again at {}", (Object)this.principalLogText(), (Object)new Date(retvalNextRefreshMs));
            return retvalNextRefreshMs;
        }
        long expireTimeMs = this.expiringCredential.expireTimeMs();
        if (relativeToMs > expireTimeMs) {
            boolean logoutRequiredBeforeLoggingBackIn = this.isLogoutRequiredBeforeLoggingBackIn();
            if (logoutRequiredBeforeLoggingBackIn) {
                log.error("[Principal={}]: Current clock: {} is later than expiry {}. This may indicate a clock skew problem. Check that this host's and remote host's clocks are in sync. Exiting refresh thread.", this.principalLogText(), new Date(relativeToMs), new Date(expireTimeMs));
                return null;
            }
            long retvalNextRefreshMs = relativeToMs + 10000L;
            log.warn("[Principal={}]: Expiring credential already expired at {}: will try to refresh again at {}", this.principalLogText(), new Date(expireTimeMs), new Date(retvalNextRefreshMs));
            return retvalNextRefreshMs;
        }
        Long absoluteLastRefreshTimeMs = this.expiringCredential.absoluteLastRefreshTimeMs();
        if (absoluteLastRefreshTimeMs != null && absoluteLastRefreshTimeMs < expireTimeMs) {
            log.warn("[Principal={}]: Expiring credential refresh thread exiting because the expiring credential's current expiration time ({}) exceeds the latest possible refresh time ({}). This process will not be able to authenticate new SASL connections after that time (for example, it will not be able to authenticate a new connection with a Kafka Broker).", this.principalLogText(), new Date(expireTimeMs), new Date(absoluteLastRefreshTimeMs));
            return null;
        }
        Long optionalStartTime = this.expiringCredential.startTimeMs();
        long startMs = optionalStartTime != null ? optionalStartTime : relativeToMs;
        log.info("[Principal={}]: Expiring credential valid from {} to {}", this.expiringCredential.principalName(), new Date(startMs), new Date(expireTimeMs));
        double pct = this.expiringCredentialRefreshConfig.loginRefreshWindowFactor() + this.expiringCredentialRefreshConfig.loginRefreshWindowJitter() * RNG.nextDouble();
        long refreshMinPeriodSeconds = this.expiringCredentialRefreshConfig.loginRefreshMinPeriodSeconds();
        long clientRefreshBufferSeconds = this.expiringCredentialRefreshConfig.loginRefreshBufferSeconds();
        if (relativeToMs + 1000L * (refreshMinPeriodSeconds + clientRefreshBufferSeconds) > expireTimeMs) {
            long retvalRefreshMs = relativeToMs + (long)((double)(expireTimeMs - relativeToMs) * pct);
            log.warn("[Principal={}]: Expiring credential expires at {}, so buffer times of {} and {} seconds at the front and back, respectively, cannot be accommodated.  We will refresh at {}.", this.principalLogText(), new Date(expireTimeMs), refreshMinPeriodSeconds, clientRefreshBufferSeconds, new Date(retvalRefreshMs));
            return retvalRefreshMs;
        }
        long proposedRefreshMs = startMs + (long)((double)(expireTimeMs - startMs) * pct);
        long beginningOfEndBufferTimeMs = expireTimeMs - clientRefreshBufferSeconds * 1000L;
        if (proposedRefreshMs > beginningOfEndBufferTimeMs) {
            log.info("[Principal={}]: Proposed refresh time of {} extends into the desired buffer time of {} seconds before expiration, so refresh it at the desired buffer begin point, at {}", this.expiringCredential.principalName(), new Date(proposedRefreshMs), clientRefreshBufferSeconds, new Date(beginningOfEndBufferTimeMs));
            return beginningOfEndBufferTimeMs;
        }
        long endOfMinRefreshBufferTime = relativeToMs + 1000L * refreshMinPeriodSeconds;
        if (proposedRefreshMs < endOfMinRefreshBufferTime) {
            log.info("[Principal={}]: Expiring credential re-login thread time adjusted from {} to {} since the former is sooner than the minimum refresh interval ({} seconds from now).", this.principalLogText(), new Date(proposedRefreshMs), new Date(endOfMinRefreshBufferTime), refreshMinPeriodSeconds);
            return endOfMinRefreshBufferTime;
        }
        return proposedRefreshMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reLogin() throws LoginException, ExitRefresherThreadDueToIllegalStateException {
        Class<?> clazz = this.mandatoryClassToSynchronizeOnPriorToRefresh;
        synchronized (clazz) {
            boolean logoutRequiredBeforeLoggingBackIn = this.isLogoutRequiredBeforeLoggingBackIn();
            if (this.hasExpiringCredential && logoutRequiredBeforeLoggingBackIn) {
                String principalLogTextPriorToLogout = this.principalLogText();
                log.info("Initiating logout for {}", (Object)principalLogTextPriorToLogout);
                this.loginContext.logout();
                this.expiringCredential = this.expiringCredential();
                boolean bl = this.hasExpiringCredential = this.expiringCredential != null;
                if (this.hasExpiringCredential) {
                    throw new ExitRefresherThreadDueToIllegalStateException(String.format("Subject's private credentials still contains an instance of %s even though logout() was invoked; exiting refresh thread", this.expiringCredential.getClass().getName()));
                }
            }
            ExpiringCredential optionalCredentialToLogout = this.expiringCredential;
            LoginContext optionalLoginContextToLogout = this.loginContext;
            boolean cleanLogin = false;
            try {
                this.loginContext = this.loginContextFactory.createLoginContext(this);
                log.info("Initiating re-login for {}, logout() still needs to be called on a previous login = {}", (Object)this.principalName, (Object)(optionalCredentialToLogout != null ? 1 : 0));
                this.loginContext.login();
                cleanLogin = true;
                if (optionalCredentialToLogout != null) {
                    optionalLoginContextToLogout.logout();
                }
            }
            finally {
                if (!cleanLogin) {
                    this.loginContext = optionalLoginContextToLogout;
                }
            }
            this.expiringCredential = this.expiringCredential();
            boolean bl = this.hasExpiringCredential = this.expiringCredential != null;
            if (!this.hasExpiringCredential) {
                log.error("No Expiring Credential after a supposedly-successful re-login");
                this.principalName = null;
            } else {
                if (this.expiringCredential == optionalCredentialToLogout) {
                    throw new ExitRefresherThreadDueToIllegalStateException(String.format("Subject's private credentials still contains the previous, soon-to-expire instance of %s even though login() followed by logout() was invoked; exiting refresh thread", this.expiringCredential.getClass().getName()));
                }
                this.principalName = this.expiringCredential.principalName();
                if (log.isDebugEnabled()) {
                    log.debug("[Principal={}]: It is an expiring credential after re-login as expected", (Object)this.principalLogText());
                }
            }
        }
    }

    private String principalLogText() {
        return this.expiringCredential == null ? this.principalName : this.expiringCredential.getClass().getSimpleName() + ":" + this.principalName;
    }

    private long currentMs() {
        return this.time.milliseconds();
    }

    private boolean isLogoutRequiredBeforeLoggingBackIn() {
        return !this.expiringCredentialRefreshConfig.loginRefreshReloginAllowedBeforeLogout();
    }

    private class Refresher
    implements Runnable {
        private Refresher() {
        }

        @Override
        public void run() {
            log.info("[Principal={}]: Expiring credential re-login thread started.", (Object)ExpiringCredentialRefreshingLogin.this.principalLogText());
            block3: while (true) {
                long nowMs;
                Long nextRefreshMs;
                if ((nextRefreshMs = ExpiringCredentialRefreshingLogin.this.refreshMs(nowMs = ExpiringCredentialRefreshingLogin.this.currentMs())) == null) {
                    ExpiringCredentialRefreshingLogin.this.loginContextFactory.refresherThreadDone();
                    return;
                }
                if (nextRefreshMs < nowMs) {
                    log.warn("[Principal={}]: Expiring credential re-login sleep time was calculated to be in the past! Will explicitly adjust. ({})", (Object)ExpiringCredentialRefreshingLogin.this.principalLogText(), (Object)new Date(nextRefreshMs));
                    nextRefreshMs = nowMs + 10000L;
                }
                log.info("[Principal={}]: Expiring credential re-login sleeping until: {}", (Object)ExpiringCredentialRefreshingLogin.this.principalLogText(), (Object)new Date(nextRefreshMs));
                ExpiringCredentialRefreshingLogin.this.time.sleep(nextRefreshMs - nowMs);
                if (Thread.currentThread().isInterrupted()) {
                    log.info("[Principal={}]: Expiring credential re-login thread has been interrupted and will exit.", (Object)ExpiringCredentialRefreshingLogin.this.principalLogText());
                    ExpiringCredentialRefreshingLogin.this.loginContextFactory.refresherThreadDone();
                    return;
                }
                while (true) {
                    try {
                        ExpiringCredentialRefreshingLogin.this.reLogin();
                        continue block3;
                    }
                    catch (ExitRefresherThreadDueToIllegalStateException e) {
                        log.error(e.getMessage(), e);
                        ExpiringCredentialRefreshingLogin.this.loginContextFactory.refresherThreadDone();
                        return;
                    }
                    catch (LoginException loginException) {
                        log.warn(String.format("[Principal=%s]: LoginException during login retry; will sleep %d seconds before trying again.", ExpiringCredentialRefreshingLogin.this.principalLogText(), 10L), loginException);
                        ExpiringCredentialRefreshingLogin.this.time.sleep(10000L);
                        if (!Thread.currentThread().isInterrupted()) continue;
                        log.error("[Principal={}]: Interrupted while trying to perform a subsequent expiring credential re-login after one or more initial re-login failures: re-login thread exiting now: {}", (Object)ExpiringCredentialRefreshingLogin.this.principalLogText(), (Object)String.valueOf(loginException.getMessage()));
                        ExpiringCredentialRefreshingLogin.this.loginContextFactory.refresherThreadDone();
                        return;
                    }
                    break;
                }
            }
        }
    }

    private static class ExitRefresherThreadDueToIllegalStateException
    extends Exception {
        private static final long serialVersionUID = -6108495378411920380L;

        public ExitRefresherThreadDueToIllegalStateException(String message) {
            super(message);
        }
    }

    static class LoginContextFactory {
        LoginContextFactory() {
        }

        public LoginContext createLoginContext(ExpiringCredentialRefreshingLogin expiringCredentialRefreshingLogin) throws LoginException {
            return new LoginContext(expiringCredentialRefreshingLogin.contextName(), expiringCredentialRefreshingLogin.subject(), expiringCredentialRefreshingLogin.callbackHandler(), expiringCredentialRefreshingLogin.configuration());
        }

        public void refresherThreadStarted() {
        }

        public void refresherThreadDone() {
        }
    }
}

