/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.SaslAuthenticateRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.SaslAuthenticateResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ApiError;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.SaslAuthenticateResponse;
import java.nio.ByteBuffer;

public class SaslAuthenticateRequest
extends AbstractRequest {
    private final SaslAuthenticateRequestData data;

    public SaslAuthenticateRequest(SaslAuthenticateRequestData data, short version) {
        super(ApiKeys.SASL_AUTHENTICATE, version);
        this.data = data;
    }

    @Override
    public SaslAuthenticateRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        SaslAuthenticateResponseData response = new SaslAuthenticateResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message());
        return new SaslAuthenticateResponse(response);
    }

    public static SaslAuthenticateRequest parse(ByteBuffer buffer, short version) {
        return new SaslAuthenticateRequest(new SaslAuthenticateRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<SaslAuthenticateRequest> {
        private final SaslAuthenticateRequestData data;

        public Builder(SaslAuthenticateRequestData data) {
            super(ApiKeys.SASL_AUTHENTICATE);
            this.data = data;
        }

        @Override
        public SaslAuthenticateRequest build(short version) {
            return new SaslAuthenticateRequest(this.data, version);
        }

        public String toString() {
            return "(type=SaslAuthenticateRequest)";
        }
    }
}

