/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.EndQuorumEpochResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EndQuorumEpochResponse
extends AbstractResponse {
    private final EndQuorumEpochResponseData data;

    public EndQuorumEpochResponse(EndQuorumEpochResponseData data) {
        super(ApiKeys.END_QUORUM_EPOCH);
        this.data = data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errors = new HashMap<Errors, Integer>();
        errors.put(Errors.forCode(this.data.errorCode()), 1);
        for (EndQuorumEpochResponseData.TopicData topicResponse : this.data.topics()) {
            for (EndQuorumEpochResponseData.PartitionData partitionResponse : topicResponse.partitions()) {
                this.updateErrorCounts(errors, Errors.forCode(partitionResponse.errorCode()));
            }
        }
        return errors;
    }

    @Override
    public EndQuorumEpochResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    public static EndQuorumEpochResponseData singletonResponse(Errors topLevelError, TopicPartition topicPartition, Errors partitionLevelError, int leaderEpoch, int leaderId) {
        return new EndQuorumEpochResponseData().setErrorCode(topLevelError.code()).setTopics(Collections.singletonList(new EndQuorumEpochResponseData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(new EndQuorumEpochResponseData.PartitionData().setErrorCode(partitionLevelError.code()).setLeaderId(leaderId).setLeaderEpoch(leaderEpoch)))));
    }

    public static EndQuorumEpochResponse parse(ByteBuffer buffer, short version) {
        return new EndQuorumEpochResponse(new EndQuorumEpochResponseData(new ByteBufferAccessor(buffer), version));
    }
}

