/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.SecurityProtocol;
import java.util.Objects;
import java.util.Optional;

@InterfaceStability.Evolving
public class Endpoint {
    private final String listenerName;
    private final SecurityProtocol securityProtocol;
    private final String host;
    private final int port;

    public Endpoint(String listenerName, SecurityProtocol securityProtocol, String host, int port) {
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.host = host;
        this.port = port;
    }

    public Optional<String> listenerName() {
        return Optional.ofNullable(this.listenerName);
    }

    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint that = (Endpoint)o;
        return Objects.equals(this.listenerName, that.listenerName) && Objects.equals((Object)this.securityProtocol, (Object)that.securityProtocol) && Objects.equals(this.host, that.host) && this.port == that.port;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.listenerName, this.securityProtocol, this.host, this.port});
    }

    public String toString() {
        return "Endpoint(listenerName='" + this.listenerName + '\'' + ", securityProtocol=" + (Object)((Object)this.securityProtocol) + ", host='" + this.host + '\'' + ", port=" + this.port + ')';
    }
}

