/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.table.catalog.ObjectPath;

public class MySqlTableSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ObjectPath tablePathInFlink;
    private final ObjectPath tablePathInMySql;
    private final boolean isShardingTable;
    private List<String> metadataKeys;

    public MySqlTableSpec(ObjectPath tablePathInFlink, ObjectPath tablePathInMySql, boolean isShardingTable) {
        this.tablePathInFlink = tablePathInFlink;
        this.tablePathInMySql = tablePathInMySql;
        this.isShardingTable = isShardingTable;
        this.metadataKeys = new ArrayList<String>();
    }

    public ObjectPath getTablePathInFlink() {
        return this.tablePathInFlink;
    }

    public ObjectPath getTablePathInMySql() {
        return this.tablePathInMySql;
    }

    public boolean isShardingTable() {
        return this.isShardingTable;
    }

    public List<String> getMetadataKeys() {
        return this.metadataKeys;
    }

    public void setMetadataKeys(List<String> metadataKeys) {
        this.metadataKeys = metadataKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlTableSpec)) {
            return false;
        }
        MySqlTableSpec that = (MySqlTableSpec)o;
        return this.isShardingTable == that.isShardingTable && Objects.equals(this.tablePathInFlink, that.tablePathInFlink) && Objects.equals(this.tablePathInMySql, that.tablePathInMySql) && Objects.equals(this.metadataKeys, that.metadataKeys);
    }

    public int hashCode() {
        return Objects.hash(this.tablePathInFlink, this.tablePathInMySql, this.isShardingTable, this.metadataKeys);
    }

    public String toString() {
        return String.format("{ tablePathInFlink: %s, tablePathInMySql: %s, isShardingTable: %s }", this.tablePathInFlink.getFullName(), this.tablePathInMySql.getFullName(), this.isShardingTable);
    }
}

