/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc.dim;

import java.io.Serializable;

public class VervericaJdbcLookupOptions
implements Serializable {
    public static final String DEFAULT_CACHE_STRATEGY = "None";
    public static final long DEFAULT_CACHE_MAX_SIZE = -1L;
    public static final long DEFAULT_CACHE_EXPIRE_MS = -1L;
    private final long cacheMaxSize;
    private final long cacheExpireMs;
    private final int maxRetryTimes;
    private final String cacheStrategy;

    private VervericaJdbcLookupOptions(long cacheMaxSize, long cacheExpireMs, int maxRetryTimes, String cacheStrategy) {
        this.cacheMaxSize = cacheMaxSize;
        this.cacheExpireMs = cacheExpireMs;
        this.maxRetryTimes = maxRetryTimes;
        this.cacheStrategy = cacheStrategy;
    }

    public long getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public long getCacheExpireMs() {
        return this.cacheExpireMs;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public boolean isCacheALL() {
        return this.cacheStrategy.equalsIgnoreCase("ALL");
    }

    public boolean isCacheLRU() {
        return this.cacheStrategy.equalsIgnoreCase("LRU");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long cacheMaxSize = -1L;
        private long cacheExpireMs = -1L;
        private int maxRetryTimes = 3;
        private String cacheStrategy = "None";

        public Builder withCacheMaxSize(long cacheMaxSize) {
            this.cacheMaxSize = cacheMaxSize;
            return this;
        }

        public Builder withCacheExpireMs(long cacheExpireMs) {
            this.cacheExpireMs = cacheExpireMs;
            return this;
        }

        public Builder withMaxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public Builder withCacheStrategy(String cacheStrategy) {
            this.cacheStrategy = cacheStrategy;
            return this;
        }

        public VervericaJdbcLookupOptions build() {
            return new VervericaJdbcLookupOptions(this.cacheMaxSize, this.cacheExpireMs, this.maxRetryTimes, this.cacheStrategy);
        }
    }
}

