/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc.dim;

import com.alibaba.ververica.connectors.common.dim.cache.AllCache;
import com.alibaba.ververica.connectors.common.dim.cache.CacheStrategy;
import com.alibaba.ververica.connectors.common.dim.reload.CacheAllReloadConf;
import com.alibaba.ververica.connectors.common.dim.reload.SerializableRunnable;
import com.alibaba.ververica.connectors.common.util.DateUtil;
import com.alibaba.ververica.connectors.jdbc.dim.JdbcRowFetcherBase;
import com.alibaba.ververica.connectors.jdbc.util.JdbcRowConverter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcAllCacheRowFetcherBase
extends JdbcRowFetcherBase {
    private static final long serialVersionUID = 6941593589582551911L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcAllCacheRowFetcherBase.class);
    private final String scanTemplate;

    public JdbcAllCacheRowFetcherBase(String sqlTableName, TableSchema tableSchema, String[] lookupKeys, CacheAllReloadConf reloadConf, int maxRetries, int maxFetchResults, String scanTemplate, Function<DataType[], JdbcRowConverter> jdbcRowConverterFunction) {
        super(sqlTableName, tableSchema, lookupKeys, CacheStrategy.all(reloadConf.ttlMs), maxRetries, maxFetchResults, scanTemplate, jdbcRowConverterFunction);
        this.setAllCacheReloadRunner(new ReloadCacheRunner(), reloadConf);
        this.scanTemplate = scanTemplate;
        LOG.info("scanTemplate is : {}", (Object)scanTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flatMap(RowData row, Collector<RowData> collector) throws Exception {
        List cachedRows;
        Object key = this.getSourceKey(row);
        if (key == null) {
            LOG.debug("Join {} on an empty key of row: {}", (Object)this.getConnectorType(), (Object)row);
            return;
        }
        while (!this.allCacheHandler.isLoadedOrThrowException()) {
            Thread.sleep(10L);
        }
        this.allCacheHandler.lock.readLock().lock();
        try {
            cachedRows = (List)this.allCacheHandler.get(key);
        }
        finally {
            this.allCacheHandler.lock.readLock().unlock();
        }
        if (cachedRows != null) {
            for (RowData cachedRow : cachedRows) {
                collector.collect((Object)cachedRow);
            }
        }
    }

    protected Connection createConnection() throws SQLException {
        if (null == this.connection || this.connection.isClosed()) {
            this.connection = this.connectToTable();
        }
        return this.connection;
    }

    protected void closePooledConnection(Connection connection) {
    }

    protected void updateCache(ResultSet rs) throws Exception {
        RowData resultRow = this.jdbcRowConverter.toInternal(rs);
        Object key = this.prepareCacheKey(resultRow);
        if (this.hasPrimaryKey) {
            this.allCacheHandler.put(key, Collections.singletonList(resultRow));
        } else {
            this.allCacheHandler.append(key, Collections.singletonList(resultRow));
        }
    }

    static /* synthetic */ CacheAllReloadConf access$100(JdbcAllCacheRowFetcherBase x0) {
        return x0.reloadConf;
    }

    static /* synthetic */ AllCache access$200(JdbcAllCacheRowFetcherBase x0) {
        return x0.allCacheHandler;
    }

    static /* synthetic */ Logger access$300() {
        return LOG;
    }

    static /* synthetic */ String access$400(JdbcAllCacheRowFetcherBase x0) {
        return x0.sqlTableName;
    }

    static /* synthetic */ AllCache access$500(JdbcAllCacheRowFetcherBase x0) {
        return x0.allCacheHandler;
    }

    static /* synthetic */ String access$600(JdbcAllCacheRowFetcherBase x0) {
        return x0.scanTemplate;
    }

    static /* synthetic */ String access$700(JdbcAllCacheRowFetcherBase x0) {
        return x0.sqlTableName;
    }

    static /* synthetic */ AllCache access$800(JdbcAllCacheRowFetcherBase x0) {
        return x0.allCacheHandler;
    }

    static /* synthetic */ AllCache access$900(JdbcAllCacheRowFetcherBase x0) {
        return x0.allCacheHandler;
    }

    static /* synthetic */ AllCache access$1000(JdbcAllCacheRowFetcherBase x0) {
        return x0.allCacheHandler;
    }

    private class ReloadCacheRunner
    extends SerializableRunnable {
        private ReloadCacheRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            attemptNum = 0;
            while (attemptNum++ < JdbcAllCacheRowFetcherBase.this.maxRetries) {
                block14: {
                    connection = null;
                    currentTime = System.currentTimeMillis();
                    if (!DateUtil.isTimeInRange(JdbcAllCacheRowFetcherBase.access$100((JdbcAllCacheRowFetcherBase)JdbcAllCacheRowFetcherBase.this).timeRangeBlackList, currentTime)) ** GOTO lbl14
                    if (!JdbcAllCacheRowFetcherBase.access$200(JdbcAllCacheRowFetcherBase.this).isLoaded()) break block14;
                    JdbcAllCacheRowFetcherBase.access$300().info("Current time {} is in reload black list, so try to reload one2oneCache next time.", (Object)currentTime);
                    JdbcAllCacheRowFetcherBase.this.closePooledConnection(connection);
                    return;
                }
                try {
                    JdbcAllCacheRowFetcherBase.access$300().info("Current time {} is in reload black list, but this is the first time to load one2oneCache, so still load.", (Object)currentTime);
lbl14:
                    // 2 sources

                    connection = JdbcAllCacheRowFetcherBase.this.createConnection();
                    JdbcAllCacheRowFetcherBase.access$300().info("Reloading all data from MySQL '{}' ...", (Object)JdbcAllCacheRowFetcherBase.access$400(JdbcAllCacheRowFetcherBase.this));
                    JdbcAllCacheRowFetcherBase.access$500(JdbcAllCacheRowFetcherBase.this).initialize();
                    startTime = System.nanoTime();
                    ps = connection.prepareStatement(JdbcAllCacheRowFetcherBase.access$600(JdbcAllCacheRowFetcherBase.this));
                    rs = ps.executeQuery();
                    readCount = 0;
                    while (rs.next()) {
                        ++readCount;
                        JdbcAllCacheRowFetcherBase.this.updateCache(rs);
                    }
                    rs.close();
                    ps.close();
                    endTime = System.nanoTime();
                    JdbcAllCacheRowFetcherBase.access$300().info("Loaded {} rows from MySQL '{}' into cache, used {} ms.", new Object[]{readCount, JdbcAllCacheRowFetcherBase.access$700(JdbcAllCacheRowFetcherBase.this), (endTime - startTime) / 1000000L});
                    JdbcAllCacheRowFetcherBase.access$800(JdbcAllCacheRowFetcherBase.this).switchCache();
                    JdbcAllCacheRowFetcherBase.this.closePooledConnection(connection);
                    break;
                }
                catch (Throwable t) {
                    try {
                        e = new RuntimeException("Error happens in reload thread.", t);
                        if (t instanceof InterruptedException || t instanceof OutOfMemoryError) {
                            JdbcAllCacheRowFetcherBase.access$300().error("Error happens when scanning all data from MySQL.", e);
                            JdbcAllCacheRowFetcherBase.access$900(JdbcAllCacheRowFetcherBase.this).setException(e);
                        } else if (attemptNum < JdbcAllCacheRowFetcherBase.this.maxRetries) {
                            JdbcAllCacheRowFetcherBase.access$300().warn("Error happens when scanning all data from MySQL, try for the {} time.", (Object)attemptNum, (Object)e);
                            try {
                                if (!JdbcAllCacheRowFetcherBase.this.isClosed) {
                                    Thread.sleep(Math.min(1000L * (long)attemptNum, 5000L));
                                }
                            }
                            catch (InterruptedException e1) {
                                JdbcAllCacheRowFetcherBase.access$300().error("Cache reload thread is interrupted", e1);
                            }
                        } else {
                            JdbcAllCacheRowFetcherBase.access$300().error("Error happens when scanning all data from MySQL.", e);
                            JdbcAllCacheRowFetcherBase.access$1000(JdbcAllCacheRowFetcherBase.this).setException(e);
                        }
                        JdbcAllCacheRowFetcherBase.this.closePooledConnection(connection);
                    }
                    catch (Throwable var12_12) {
                        JdbcAllCacheRowFetcherBase.this.closePooledConnection(connection);
                        throw var12_12;
                    }
                }
            }
        }
    }
}

