/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc.dim;

import com.alibaba.ververica.connectors.common.dim.cache.AllCache;
import com.alibaba.ververica.connectors.common.dim.cache.CacheFactory;
import com.alibaba.ververica.connectors.common.dim.cache.CacheStrategy;
import com.alibaba.ververica.connectors.common.exception.ConnectorException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.inference.TypeTransformations;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AllCacheLookupFunction<K, V>
extends TableFunction<V> {
    private static final Logger LOG = LoggerFactory.getLogger(AllCacheLookupFunction.class);
    private transient AllCache<K, List<V>> allCache;
    private transient CacheFactory cacheFactory;
    private transient ScheduledExecutorService reloadExecutor = null;
    private final CacheStrategy cacheStrategy = CacheStrategy.all();
    private final String tableName;
    private final long ttlMs;

    public AllCacheLookupFunction(String tableName, long ttlMs) {
        this.tableName = tableName;
        this.ttlMs = ttlMs;
    }

    public abstract void openConnection();

    public abstract void closeConnection();

    public abstract K geCacheKey(Object ... var1);

    public abstract void scanTable(Map<K, List<V>> var1) throws SQLException, ClassNotFoundException;

    public abstract List<DataType> getArgumentDataTypes();

    public abstract DataType getOutputDataType();

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        List argDataTypes = this.getArgumentDataTypes().stream().map(type -> DataTypeUtils.transform((DataType)type, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.TO_INTERNAL_CLASS})).collect(Collectors.toList());
        return TypeInference.newBuilder().typedArguments(argDataTypes).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypeUtils.transform((DataType)this.getOutputDataType(), (TypeTransformation[])new TypeTransformation[]{TypeTransformations.TO_INTERNAL_CLASS}))).build();
    }

    public void open(FunctionContext context) throws Exception {
        this.cacheFactory = CacheFactory.getInstance();
        this.allCache = (AllCache)this.cacheFactory.getCache(this.tableName, this.cacheStrategy, true);
        super.open(context);
        this.openConnection();
        if (this.allCache.isRegisteredTimer.compareAndSet(false, true)) {
            this.reloadExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("allCache-reload").setDaemon(true).build());
            ScheduledFuture<?> future = this.reloadExecutor.scheduleWithFixedDelay(new Thread(new ReloadCacheRunner()), 0L, this.ttlMs, TimeUnit.MILLISECONDS);
            this.allCache.setScheduledFuture(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(Object ... keys) {
        List<V> values;
        try {
            while (!this.allCache.isLoadedOrThrowException()) {
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            throw new ConnectorException("AllCache exception.", e);
        }
        K cacheKey = this.geCacheKey(keys);
        this.allCache.lock.readLock().lock();
        try {
            values = this.allCache.get(cacheKey);
        }
        finally {
            this.allCache.lock.readLock().unlock();
        }
        if (values != null) {
            for (V value : values) {
                this.collect(value);
            }
        }
    }

    public void close() throws Exception {
        try {
            if (this.cacheStrategy.isAllCache()) {
                ScheduledFuture<?> future = this.allCache.getScheduledFuture();
                if (future != null) {
                    future.cancel(true);
                }
                if (null != this.reloadExecutor && !this.reloadExecutor.isShutdown()) {
                    this.reloadExecutor.shutdownNow();
                    this.reloadExecutor = null;
                }
            }
            this.closeConnection();
        }
        catch (Exception e) {
            LOG.error("Error happens when shutdown reload executor.", e);
        }
        finally {
            if (this.cacheStrategy.isAllCache()) {
                this.allCache.isRegisteredTimer.compareAndSet(true, false);
            }
        }
        LOG.info("Release cache of table : {} ", (Object)this.tableName);
        this.cacheFactory.removeCache(this.tableName);
        super.close();
    }

    private class ReloadCacheRunner
    implements Serializable,
    Runnable {
        private ReloadCacheRunner() {
        }

        @Override
        public void run() {
            AllCacheLookupFunction.this.allCache.initialize();
            try {
                AllCacheLookupFunction.this.scanTable(AllCacheLookupFunction.this.allCache.getTempCache());
            }
            catch (Throwable t) {
                ConnectorException e = new ConnectorException("Error happens in reload thread.", t);
                LOG.error("Error happens when scanning all data from MySQL.", e);
                AllCacheLookupFunction.this.allCache.setException(e);
            }
            AllCacheLookupFunction.this.allCache.switchCache();
        }
    }
}

