/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source.resolver.parse;

import com.alibaba.ververica.connectors.common.errorcode.ConnectorErrors;
import com.alibaba.ververica.connectors.common.source.message.RawMessage;
import com.alibaba.ververica.connectors.common.util.ByteSerializer;
import com.alibaba.ververica.connectors.common.util.StringSerializer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHighSpeedParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHighSpeedParser.class);
    private static final int DEFAULT_LOG_INTERVAL_MS = 60000;
    final int columnSize;
    final ByteSerializer.ValueType[] fieldTypes;
    final DataType[] fieldDataTypes;
    final String fieldDelimiter;
    final boolean splitByWholeSeparator;
    final byte[][] bytesNullValues;
    private final boolean columnErrorDebug;
    private long lastLogExceptionTime;
    private long lastLogHandleFieldTime;

    AbstractHighSpeedParser(ByteSerializer.ValueType[] fieldTypes, DataType[] fieldDataTypes, String fieldDelimiter, boolean splitByWholeSeparator, List<String> nullValues, boolean columnErrorDebug) {
        this.columnSize = fieldTypes.length;
        this.fieldTypes = fieldTypes;
        this.fieldDataTypes = fieldDataTypes;
        this.fieldDelimiter = fieldDelimiter;
        this.splitByWholeSeparator = splitByWholeSeparator;
        this.bytesNullValues = new byte[nullValues.size()][];
        for (int i = 0; i < nullValues.size(); ++i) {
            this.bytesNullValues[i] = nullValues.get(i).getBytes(StandardCharsets.UTF_8);
        }
        this.columnErrorDebug = columnErrorDebug;
    }

    boolean isNullField(byte[] array, int start, int len) {
        block0: for (byte[] nullBytes : this.bytesNullValues) {
            if (nullBytes.length != len) continue;
            for (int i = 0; i < len; ++i) {
                if (array[start + i] != nullBytes[i]) continue block0;
            }
            return true;
        }
        return false;
    }

    @Nullable
    Object deserializeBinary(byte[] array, int start, int end, int fieldOrdinal, Object reuseObj, MemorySegment[] reuseSegs) {
        int len = end - start;
        ByteSerializer.ValueType type = this.fieldTypes[fieldOrdinal];
        switch (type) {
            case V_ByteArray: {
                byte[] copy = new byte[len];
                System.arraycopy(array, start, copy, 0, len);
                return copy;
            }
            case V_String: {
                BinaryStringData binaryString = (BinaryStringData)reuseObj;
                binaryString.getBinarySection().pointTo(reuseSegs, start, len);
                binaryString.setJavaObject(null);
                return binaryString;
            }
            case V_Byte: {
                if (len == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[start];
            }
            case V_Short: {
                return Short.parseShort(new String(array, start, len));
            }
            case V_Integer: {
                return Integer.parseInt(new String(array, start, len));
            }
            case V_Long: {
                return Long.parseLong(new String(array, start, len));
            }
            case V_Float: {
                return Float.valueOf(Float.parseFloat(new String(array, start, len)));
            }
            case V_Double: {
                return Double.parseDouble(new String(array, start, len));
            }
            case V_Boolean: {
                return StringSerializer.parseBoolean(new String(array, start, len));
            }
            case V_LocalDateTime: 
            case V_Timestamp: {
                try {
                    return StringSerializer.timestampConverter.toInternal((Object)new Timestamp(Long.parseLong(new String(array, start, len))));
                }
                catch (NumberFormatException e) {
                    return StringSerializer.timestampConverter.toInternal((Object)Timestamp.valueOf(new String(array, start, len)));
                }
            }
            case V_LocalDate: 
            case V_Date: {
                return DataFormatConverters.DateConverter.INSTANCE.toInternal((Object)Date.valueOf(new String(array, start, len)));
            }
            case V_LocalTime: 
            case V_Time: {
                return DataFormatConverters.TimeConverter.INSTANCE.toInternal((Object)new Time(Long.parseLong(new String(array, start, len))));
            }
            case V_BigDecimal: {
                DecimalType decimalType = (DecimalType)this.fieldDataTypes[fieldOrdinal].getLogicalType();
                return DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(new String(array, start, len)), (int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
        }
        throw new IllegalArgumentException(ConnectorErrors.INST.dataTypeError(type.toString()));
    }

    void logFieldMiss(byte[] array, int start, int len) {
        long now = System.currentTimeMillis();
        if (this.columnErrorDebug || now - this.lastLogHandleFieldTime > 60000L) {
            Object[] data = this.toFieldStringArray(array, start, len);
            LOGGER.warn("Field missing error, table column number: " + this.columnSize + ", data column number: " + this.columnSize + ", data field number: " + data.length + ", data: [" + StringUtils.join((Object[])data, (String)",") + "]");
            this.lastLogHandleFieldTime = now;
        }
    }

    void logExtraField(byte[] array, int start, int len) {
        long now = System.currentTimeMillis();
        if (this.columnErrorDebug || now - this.lastLogHandleFieldTime > 60000L) {
            Object[] data = this.toFieldStringArray(array, start, len);
            LOGGER.warn("Field increment error, table column number: " + this.columnSize + ", data column number: " + this.columnSize + ", data field number: " + data.length + ", data: [" + StringUtils.join((Object[])data, (String)",") + "]");
            this.lastLogHandleFieldTime = now;
        }
    }

    void logParseException(byte[] array, int start, int len, int idx, Exception cause) {
        long now = System.currentTimeMillis();
        if (this.columnErrorDebug || now - this.lastLogExceptionTime > 60000L) {
            Object[] data = this.toFieldStringArray(array, start, len);
            LOGGER.warn("Data format error, field type: " + (Object)((Object)this.fieldTypes[idx]) + "field data: " + data[idx] + ", index: " + idx + ", data: [" + StringUtils.join((Object[])data, (String)",") + "]", cause);
            this.lastLogExceptionTime = now;
        }
    }

    String[] toFieldStringArray(byte[] array, int start, int len) {
        String line = new String(array, start, len);
        String[] data = !this.splitByWholeSeparator ? StringUtils.splitPreserveAllTokens((String)line, (String)this.fieldDelimiter) : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)line, (String)this.fieldDelimiter);
        return data;
    }

    public abstract void parseBytesMessageByBinary(Collector<RowData> var1, RawMessage<?> var2);
}

