/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source.reader;

import com.alibaba.ververica.connectors.common.util.ConnectionPool;
import java.io.Serializable;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPartitionNumsListener
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(AbstractPartitionNumsListener.class);
    private static ConnectionPool<Timer> timerPool = new ConnectionPool();
    protected int initPartitionCount = -1;
    private boolean partitionChanged = false;
    private transient Timer listener;

    public void initPartitionNumsListener() {
        this.scheduleListener();
    }

    public abstract int getPartitionsNums();

    public abstract String getReaderName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleListener() {
        Class<AbstractPartitionNumsListener> clazz = AbstractPartitionNumsListener.class;
        synchronized (AbstractPartitionNumsListener.class) {
            if (timerPool.contains(this.getReaderName())) {
                this.listener = timerPool.get(this.getReaderName());
            } else {
                this.listener = new Timer("Partition Change " + this.getReaderName() + "-Listener");
                this.listener.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(new Random().nextInt(300) * 1000);
                            int partitionsNums = AbstractPartitionNumsListener.this.getPartitionsNums();
                            AbstractPartitionNumsListener.this.partitionNumsChangeListener(partitionsNums, AbstractPartitionNumsListener.this.initPartitionCount);
                        }
                        catch (Throwable e) {
                            logger.error("Get partition of " + AbstractPartitionNumsListener.this.getReaderName() + " Error", e);
                        }
                    }
                }, 60000L, 300000L);
                timerPool.put(this.getReaderName(), this.listener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void triggerPartitionNumFailOver() {
        this.partitionChanged = true;
        logger.error(String.format("shards number of the logStore[%s] has changed, pls adjust source parallelism configuration and then do restart.", this.getReaderName()));
    }

    protected void partitionNumsChangeListener(int newPartitionsCount, int initPartitionCount) {
        if (newPartitionsCount != initPartitionCount) {
            this.triggerPartitionNumFailOver();
        }
    }

    public int getInitPartitionCount() {
        return this.initPartitionCount;
    }

    public AbstractPartitionNumsListener setInitPartitionCount(int initPartitionCount) {
        this.initPartitionCount = initPartitionCount;
        return this;
    }

    public boolean isPartitionChanged() {
        return this.partitionChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyPartitionNumsListener() {
        Class<AbstractPartitionNumsListener> clazz = AbstractPartitionNumsListener.class;
        synchronized (AbstractPartitionNumsListener.class) {
            if (timerPool.remove(this.getReaderName()) && null != this.listener) {
                this.listener.cancel();
                this.listener = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

