/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.Constraint;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class SourceUtils {
    public static List<Integer> modAssign(String sourceName, int consumerCount, int consumerIndex, int partitions) {
        SourceUtils.argumentsCheck(sourceName, consumerCount, consumerIndex, partitions);
        LinkedList<Integer> assignedPartitions = new LinkedList<Integer>();
        for (int i = 0; i < partitions; ++i) {
            if (i % consumerCount != consumerIndex) continue;
            assignedPartitions.add(i);
        }
        return assignedPartitions;
    }

    public static List<Integer> divisionAssign(String sourceName, int consumerCount, int consumerIndex, int partitions) {
        SourceUtils.argumentsCheck(sourceName, consumerCount, consumerIndex, partitions);
        Preconditions.checkState((partitions % consumerCount == 0 ? 1 : 0) != 0);
        LinkedList<Integer> assignedPartitions = new LinkedList<Integer>();
        int assignedPartitionCount = partitions / consumerCount;
        int startIndex = assignedPartitionCount * consumerIndex;
        for (int i = 0; i < assignedPartitionCount; ++i) {
            assignedPartitions.add(startIndex + i);
        }
        return assignedPartitions;
    }

    public static List<Integer> divisionModAssign(String sourceName, int consumerCount, int consumerIndex, int partitions) {
        SourceUtils.argumentsCheck(sourceName, consumerCount, consumerIndex, partitions);
        LinkedList<Integer> assignedPartitions = new LinkedList<Integer>();
        int assignedPartitionCount = partitions / consumerCount;
        int startIndex = assignedPartitionCount * consumerIndex;
        for (int i = 0; i < assignedPartitionCount; ++i) {
            assignedPartitions.add(startIndex + i);
        }
        int modAssigned = assignedPartitionCount * consumerCount + consumerIndex;
        if (partitions > modAssigned) {
            assignedPartitions.add(modAssigned);
        }
        return assignedPartitions;
    }

    public static Tuple2<Long, Long> rangeAssign(String sourceName, int consumerCount, int consumerIndex, long totalRecordCount) {
        SourceUtils.argumentsCheck(sourceName, consumerCount, consumerIndex);
        if (totalRecordCount <= (long)consumerIndex) {
            return null;
        }
        long assignedPartitionCount = totalRecordCount / (long)consumerCount;
        if (assignedPartitionCount == 0L) {
            return new Tuple2((Object)consumerIndex, (Object)1L);
        }
        long startIndex = assignedPartitionCount * (long)consumerIndex;
        long count = consumerIndex + 1 == consumerCount ? totalRecordCount - startIndex : assignedPartitionCount;
        return new Tuple2((Object)startIndex, (Object)count);
    }

    public static Long parseDateString(String formatString, String dateString) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatString);
        return simpleDateFormat.parse(dateString).getTime();
    }

    public static Long parseDateString(String formatString, String dateString, String timeZone) throws ParseException {
        FastDateFormat simpleDateFormat = FastDateFormat.getInstance((String)formatString, (TimeZone)TimeZone.getTimeZone(timeZone));
        return simpleDateFormat.parse(dateString).getTime();
    }

    public static String toDateString(String formatString, Long ts) {
        Timestamp timestamp = new Timestamp(ts);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatString);
        return simpleDateFormat.format(timestamp);
    }

    protected static void argumentsCheck(String sourceName, int consumerCount, int consumerIndex, int partitions) {
        SourceUtils.argumentsCheck(sourceName, consumerCount, consumerIndex);
        Preconditions.checkArgument((partitions > 0 ? 1 : 0) != 0, (Object)("Source: [" + sourceName + "], partition count: " + partitions + " must be more than 0."));
    }

    protected static void argumentsCheck(String sourceName, int consumerCount, int consumerIndex) {
        Preconditions.checkArgument((consumerCount > 0 ? 1 : 0) != 0, (Object)("Source: [" + sourceName + "], Consumer count: " + consumerCount + " must be more than 0."));
        Preconditions.checkElementIndex((int)consumerIndex, (int)consumerCount, (String)("Source: [" + sourceName + "], Consumer index: " + consumerIndex + " is out of range of consumer count: " + consumerCount));
    }

    public static <T> T deserializeObject(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object ret = ois.readObject();
        ois.close();
        return (T)ret;
    }

    public static <T> T cloneObject(T src) throws IOException, ClassNotFoundException {
        return SourceUtils.deserializeObject(InstantiationUtil.serializeObject(src));
    }

    public static boolean hasValidPrimaryKey(TableSchema tableSchema, String[] lookupKeys) {
        Optional optionalUniqueConstraint = tableSchema.getPrimaryKey();
        if (!optionalUniqueConstraint.isPresent()) {
            return false;
        }
        UniqueConstraint uniqueConstraint = (UniqueConstraint)optionalUniqueConstraint.get();
        if (uniqueConstraint.getType() != Constraint.ConstraintType.PRIMARY_KEY) {
            return false;
        }
        List<String> keysList = Arrays.asList(lookupKeys);
        List pkColums = uniqueConstraint.getColumns();
        for (String col : pkColums) {
            if (keysList.contains(col)) continue;
            return false;
        }
        return true;
    }
}

