/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim.cache;

import com.alibaba.ververica.connectors.common.dim.cache.AllCache;
import com.alibaba.ververica.connectors.common.dim.cache.NativeAllCacheSharedResource;
import com.alibaba.ververica.connectors.common.dim.cache.NativeCacheUtils;
import java.io.IOException;
import org.apache.flink.streaming.natives.VectorizedDataChunk;
import org.apache.flink.streaming.natives.type.NativeRowType;
import org.apache.flink.table.runtime.natives.NativeTableTypeUtils;
import org.apache.flink.table.runtime.natives.PlainRowDataEncoder;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NativeAllCacheBase<V>
extends AllCache<Object, V> {
    private static final Logger LOG = LoggerFactory.getLogger(NativeAllCacheBase.class);
    private final String tableName;
    private int batchSize;
    private long offHeapMemorySize;
    private RowDataSerializer rowDataSerializer;
    private RowType rowType = null;
    private VectorizedDataChunk reusedLookupVector;
    private volatile boolean isInitialized = false;
    private volatile boolean isRemoved = false;
    private volatile transient long nativeLookupTableAddr;
    protected transient PlainRowDataEncoder encoder;

    public NativeAllCacheBase(String tableName) {
        this.tableName = tableName;
    }

    protected abstract boolean hasPrimaryKey();

    public NativeAllCacheBase<V> setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public NativeAllCacheBase<V> setOffHeapMemorySize(long offHeapMemorySize) {
        this.offHeapMemorySize = offHeapMemorySize;
        return this;
    }

    public NativeAllCacheBase<V> setRowDataSerializer(RowDataSerializer rowDataSerializer) {
        this.rowDataSerializer = rowDataSerializer;
        return this;
    }

    public NativeAllCacheBase<V> setRowType(RowType rowType) {
        this.rowType = rowType;
        return this;
    }

    @Override
    public V get(Object key) {
        throw new UnsupportedOperationException("We should not call get() method in Native Cache.");
    }

    @Override
    public synchronized void initialize() {
        super.initialize();
        if (!this.isInitialized) {
            LOG.info("Initialize Native All Cache: {} for first time and create data structures in native side.", (Object)this.tableName);
            long lookupTableDescriptor = NativeCacheUtils.initializeLookupTable((long)this.nativeLookupTableAddr);
            Preconditions.checkArgument((lookupTableDescriptor != 0L ? 1 : 0) != 0);
            this.reusedLookupVector = new VectorizedDataChunk(lookupTableDescriptor);
            this.encoder = new PlainRowDataEncoder(this.batchSize, (NativeRowType)NativeTableTypeUtils.toNativeType((LogicalType)this.rowType), this.rowDataSerializer, NativeAllCacheSharedResource.getInstance().getMemoryPool());
            this.encoder.initReusedResult(this.reusedLookupVector);
            this.isInitialized = true;
        } else {
            NativeCacheUtils.resetWriteLookupTable((long)this.nativeLookupTableAddr);
            LOG.info("Initialize Native All Cache: {} after resetting lookup table for insertion.", (Object)this.tableName);
        }
    }

    public synchronized void open(long nativeLookupJoinOperatorAddr) {
        LOG.info("Open Native All Cache...");
        Preconditions.checkArgument((nativeLookupJoinOperatorAddr != 0L ? 1 : 0) != 0);
        this.nativeLookupTableAddr = this.createLookupTable(nativeLookupJoinOperatorAddr);
        Preconditions.checkArgument((this.nativeLookupTableAddr != 0L ? 1 : 0) != 0);
    }

    public long createLookupTable(long nativeLookupJoinOperatorAddr) {
        NativeAllCacheSharedResource.setQuota(this.offHeapMemorySize);
        return NativeCacheUtils.createLookupTable((long)nativeLookupJoinOperatorAddr, (long)NativeAllCacheSharedResource.getInstance().getMemoryPool().getNativeMemoryPool(), (String)this.tableName, (boolean)this.hasPrimaryKey());
    }

    public synchronized void removeLookupTable() {
        this.isRemoved = true;
        NativeCacheUtils.removeLookupTable((String)this.tableName);
    }

    @Override
    public synchronized void switchCache() {
        this.lock.writeLock().lock();
        try {
            if (!this.isRemoved) {
                LOG.info("Switch Native All Cache: {}", (Object)this.tableName);
                this.flush();
                NativeCacheUtils.switchLookupTableCache((long)this.nativeLookupTableAddr);
            } else {
                LOG.info("The Native All Cache of {} is removed. Skip switch cache.", (Object)this.tableName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.setLastUpdated(System.currentTimeMillis());
    }

    @Override
    public synchronized long size() {
        this.lock.readLock().lock();
        try {
            if (!this.isRemoved) {
                long l = NativeCacheUtils.getLookupTableSize((long)this.nativeLookupTableAddr);
                return l;
            }
            LOG.info("The Native All Cache of {} is removed. Skip reading size.", (Object)this.tableName);
            long l = 0L;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected synchronized void flush() throws IOException {
        if (this.encoder != null && !this.isRemoved) {
            try {
                int count = this.encoder.flush();
                NativeCacheUtils.insertBatchToLookupTable((long)this.nativeLookupTableAddr, (int)count);
            }
            finally {
                this.encoder.reset();
            }
        }
    }
}

