/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim.cache;

import com.alibaba.ververica.connectors.common.dim.DimOptions;
import com.alibaba.ververica.connectors.common.dim.cache.CacheStrategy;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ReadableConfig;

public class CacheConfig
implements Serializable {
    private static final long serialVersionUID = 1986405660759746166L;
    private final CacheStrategy cacheStrategy;
    private final List<Tuple2<Long, Long>> timeRangeBlacklist;
    private final int cacheScanLimit;

    public CacheConfig(CacheStrategy cacheStrategy, List<Tuple2<Long, Long>> timeRangeBlacklist, int cacheScanLimit) {
        this.cacheStrategy = cacheStrategy;
        this.timeRangeBlacklist = timeRangeBlacklist;
        this.cacheScanLimit = cacheScanLimit;
    }

    public CacheConfig(CacheStrategy cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
        this.timeRangeBlacklist = Collections.emptyList();
        this.cacheScanLimit = -1;
    }

    public CacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public List<Tuple2<Long, Long>> getTimeRangeBlacklist() {
        return this.timeRangeBlacklist;
    }

    public int getCacheScanLimit() {
        return this.cacheScanLimit;
    }

    public static CacheConfig createCacheConfig(ReadableConfig config) {
        return CacheConfig.createCacheConfig(config, (String)DimOptions.CACHE_TYPE.defaultValue());
    }

    public static CacheConfig createCacheConfig(ReadableConfig config, String defaultType) {
        String cacheType = defaultType;
        if (config.getOptional(DimOptions.CACHE_TYPE).isPresent()) {
            cacheType = (String)config.get(DimOptions.CACHE_TYPE);
        }
        if (cacheType.equalsIgnoreCase("LRU")) {
            return new CacheConfig(CacheStrategy.lru((Long)config.get(DimOptions.MAX_CACHE_SIZE), (Long)config.get(DimOptions.CACHE_TTL), false, (Boolean)config.get(DimOptions.CACHE_EMPTY)), DimOptions.parseTimeRangeBlacklist((String)config.get(DimOptions.CACHE_RELOAD_TIME_BLACKLIST)), (Integer)config.get(DimOptions.CACHE_SCAN_LIMIT));
        }
        if (cacheType.equalsIgnoreCase("ALL")) {
            return new CacheConfig(CacheStrategy.all((Long)config.get(DimOptions.CACHE_TTL)));
        }
        return new CacheConfig(CacheStrategy.none());
    }
}

