/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common;

import com.alibaba.ververica.connectors.common.metrics.SimpleGauge;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.table.functions.FunctionContext;

public class MetricUtils {
    public static final String METRICS_TAG_CONNECTOR_TYPE = "connector_type";
    public static final String SINK_METRIC_GROUP = "sink";
    public static final String SOURCE_METRIC_GROUP = "source";

    public static Meter registerNumRecordBatchesInRate(RuntimeContext context) {
        return context.getMetricGroup().meter("numRecordBatchesInPerSecond", (Meter)new MeterView((Counter)new SimpleCounter()));
    }

    public static Meter registerNumRecordsInRate(FunctionContext context) {
        return MetricUtils.registerNumRecordsInRate(context.getMetricGroup());
    }

    public static Meter registerNumRecordsInRate(RuntimeContext context) {
        return MetricUtils.registerNumRecordsInRate((MetricGroup)context.getMetricGroup());
    }

    public static Meter registerNumRecordsInRate(MetricGroup metricGroup) {
        Counter numRecordsInCounter = ((OperatorMetricGroup)metricGroup).getIOMetricGroup().getNumRecordsInCounter();
        MeterView numRecordsInRateMeter = new MeterView(numRecordsInCounter);
        MetricGroup sourceMetricGroup = metricGroup.addGroup(SOURCE_METRIC_GROUP);
        sourceMetricGroup.counter("numRecordsIn", numRecordsInCounter);
        sourceMetricGroup.meter("numRecordsInPerSecond", (Meter)numRecordsInRateMeter);
        return numRecordsInRateMeter;
    }

    public static Counter registerNumRecordsInErrors(FunctionContext context) {
        return context.getMetricGroup().counter("numRecordsInErrors");
    }

    public static Meter registerNumBytesInRate(FunctionContext context, String sourceType) {
        return MetricUtils.registerNumBytesInRate(context.getMetricGroup(), sourceType);
    }

    public static Meter registerNumBytesInRate(RuntimeContext context, String sourceType) {
        return MetricUtils.registerNumBytesInRate((MetricGroup)context.getMetricGroup(), sourceType);
    }

    public static Meter registerNumBytesInRate(MetricGroup metricGroup, String sourceType) {
        String taggedNumBytesIn = MetricUtils.maybeAppendConnectorTypeTag("numBytesIn", sourceType);
        String taggedNumBytesInRate = MetricUtils.maybeAppendConnectorTypeTag("numBytesInPerSecond", sourceType);
        MetricGroup sourceMetricGroup = metricGroup.addGroup(SOURCE_METRIC_GROUP);
        Counter numBytesInCounter = metricGroup.counter(taggedNumBytesIn);
        sourceMetricGroup.counter("numBytesIn", numBytesInCounter);
        MeterView meter = new MeterView(numBytesInCounter);
        metricGroup.meter(taggedNumBytesInRate, (Meter)meter);
        sourceMetricGroup.meter(taggedNumBytesInRate, (Meter)meter);
        return meter;
    }

    public static Meter registerNumRecordsOutRate(RuntimeContext context) {
        Counter numRecordsOutCounter = context.getMetricGroup().getIOMetricGroup().getNumRecordsOutCounter();
        MeterView numRecordsOutRate = new MeterView(numRecordsOutCounter);
        context.getMetricGroup().addGroup(SINK_METRIC_GROUP).meter("numRecordsOutPerSecond", (Meter)numRecordsOutRate);
        context.getMetricGroup().addGroup(SINK_METRIC_GROUP).counter("numRecordsOut", numRecordsOutCounter);
        return numRecordsOutRate;
    }

    public static Meter registerNumBytesOutRate(RuntimeContext context, String connectorType) {
        String taggedNumBytesOut = MetricUtils.maybeAppendConnectorTypeTag("numBytesOut", connectorType);
        String taggedNumBytesOutRate = MetricUtils.maybeAppendConnectorTypeTag("numBytesOutPerSecond", connectorType);
        OperatorMetricGroup metricGroup = context.getMetricGroup();
        MetricGroup sinkMetricGroup = metricGroup.addGroup(SINK_METRIC_GROUP);
        Counter numBytesOutCounter = metricGroup.counter(taggedNumBytesOut);
        sinkMetricGroup.counter("numBytesOut", numBytesOutCounter);
        MeterView meter = new MeterView(numBytesOutCounter);
        metricGroup.meter(taggedNumBytesOutRate, (Meter)meter);
        sinkMetricGroup.meter(taggedNumBytesOutRate, (Meter)meter);
        return meter;
    }

    public static SimpleGauge registerCurrentSendTime(RuntimeContext context) {
        return (SimpleGauge)context.getMetricGroup().gauge("currentSendTime", (Gauge)new SimpleGauge());
    }

    public static Counter registerSinkDeleteCounter(RuntimeContext context) {
        return context.getMetricGroup().addGroup(SINK_METRIC_GROUP).counter("del");
    }

    public static Counter registerSinkDeleteCounter(Sink.InitContext context) {
        return context.metricGroup().addGroup(SINK_METRIC_GROUP).counter("del");
    }

    public static Counter registerNumRecordsOutErrors(RuntimeContext context) {
        return context.getMetricGroup().counter("numRecordsOutErrors", (Counter)new SimpleCounter());
    }

    private static String maybeAppendConnectorTypeTag(String name, String connectorType) {
        return name;
    }
}

