#!/bin/bash
set -e

source ./config
BUILD_DIR=$(cd `dirname $0`; pwd)
LOG_DIR=${BUILD_DIR}/logs
LOG=${LOG_DIR}/tt_$1.log
> $LOG # clear the log

echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` ,Throughtput test $1 started." | tee -a $LOG 2>&1
if [ $1 -ne 2 ]; then
  ./run_stream.sh 1 | tee -a $LOG 2>&1 &
  ./run_stream.sh 2 | tee -a $LOG 2>&1 &
  ./run_stream.sh 3 | tee -a $LOG 2>&1 &
  ./run_stream.sh 4 | tee -a $LOG 2>&1 &
else
  ./run_stream.sh 5 | tee -a $LOG 2>&1 &
  ./run_stream.sh 6 | tee -a $LOG 2>&1 &
  ./run_stream.sh 7 | tee -a $LOG 2>&1 &
  ./run_stream.sh 8 | tee -a $LOG 2>&1 &
fi

wait
echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` ,Throughtput test $1 finished." | tee -a $LOG 2>&1
