#!/bin/bash

set -x
source ./config
WORK_DIR=$(cd `dirname $0`; pwd)
BUILD_DIR=${WORK_DIR}
LOG_DIR=${BUILD_DIR}/logs
if [ $# -lt 1 ] ; then
    echo "$0 parallel_num";
    exit 0;
fi
report_name=$2
start=$(($(date +%s%N)/1000000))
echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` ,Run test $1 started."


if [ "${HAVE_SCHEMA}"x == "true"x ]
   then
      STREAM_QUERY_DIR=${BUILD_DIR}/queries_${SF}/stream_schema_$1
   else
      STREAM_QUERY_DIR=${BUILD_DIR}/queries_${SF}/stream_$1
fi
STREAM_QUERY_RESULT_DIR=$LOG_DIR/stream_$1

rm -rf console_test_result.csv
echo 'queryname','subqueryId','E2Ecost','logview' >>console_test_result.csv

if [ "$1"x != ""x ] && [ "${MODE}"x == "MCQA"x ]
then
	rm -rf clt$1
        rm -rf odps_clt/conf/.session/
	cp -rf odps_clt clt$1
        echo " " >> clt$1/conf/odps_config.ini
        echo "enable_interactive_mode=true" >> clt$1/conf/odps_config.ini
        echo "interactive_auto_rerun=false" >> clt$1/conf/odps_config.ini
        echo "interactive_service_name=${SESSION_NAME}" >> clt$1/conf/odps_config.ini
	echo "debug=true" >> clt$1/conf/odps_config.ini
	rm -rf clt$1/conf/.odpscmd_interactive_cache
	rm -rf clt$1/conf/.odpscmd_interactive_cache_lock

ODPS_CLT_CMD=${WORK_DIR}/clt$1/bin/odpscmd
${ODPS_CLT_CMD} --project ${PROJECT} -e "set odps.sql.session.result.cache.enable=false; select version();"
fi

mkdir -p ${STREAM_QUERY_RESULT_DIR}
rm -rf ${STREAM_QUERY_RESULT_DIR}/*
mkdir -p ${STREAM_QUERY_RESULT_DIR}/logview
mkdir -p ${STREAM_QUERY_RESULT_DIR}/query_running_log/
> ${LOG_DIR}/stream_$1_timeing.log
cp config ${STREAM_QUERY_RESULT_DIR}/
> ${LOG_DIR}/stream_$1_get_logvew
for i in $(seq 1 99); do
echo $i
query_start=$(($(date +%s%N)/1000000))
query_start_date=`date '+%Y-%m-%d %H:%M:%S.%2N'`
query_name=`head -n 1 ${STREAM_QUERY_DIR}/query$i.sql |awk '{print $NF}' |awk -F '.' '{print $1}'`
query_index=`echo ${query_name} |sed -e 's/query//g'`

if [ ${query_index} -lt 10 ]
then
	query_name="query0${query_index}"
fi
if [ "${MAXQA_QUOTA_NAME}"x != ""x ]
then
   extra_sql="use quota ${MAXQA_QUOTA_NAME};"
fi

${ODPS_CLT_CMD} --project ${PROJECT} --lite -e "${extra_sql}$SQL_FLAGS;set tpcds.query.name=${query_name};" -f ${STREAM_QUERY_DIR}/query$i.sql > ${STREAM_QUERY_RESULT_DIR}/${query_name}.out 2>${STREAM_QUERY_RESULT_DIR}/${query_name}.err;

query_end=$(($(date +%s%N)/1000000))
query_end_date=`date '+%Y-%m-%d %H:%M:%S.%2N'`
query_duration=$(((query_end - query_start) / 1000))
ms=`bc <<< "scale=3; ($query_end - $query_start)"`
elapse_time=`printf "%d:%02d:%02d, %s ms" $(($query_duration / 3600)) $((($query_duration / 60) % 60)) $(($query_duration % 60)) $ms`

if [ "${MODE}"x == "MCQA"x ]
then

sec=0
grep 'rerun in offline mode' ${STREAM_QUERY_RESULT_DIR}/${query_name}.err
ret=$?
if [ $ret != 0 ]; then
   echo "MCQA mode!"
   query_num=`grep subQuery ${STREAM_QUERY_RESULT_DIR}/${query_name}.err |wc -l`
   for i in $(seq 1 ${query_num})
   do
  	 if [ ${query_num} -gt 1 ]
   	then
   		result_file_name=${query_name}_${i}.err.new
   		query_name_new=${query_name}_${i}
   	else
   		result_file_name=${query_name}.err.new
   		query_name_new=${query_name}
   	fi
   >${STREAM_QUERY_RESULT_DIR}/${result_file_name}
   echo "Log view:" >>${STREAM_QUERY_RESULT_DIR}/${result_file_name}
   query_logview=`grep 'subQuery=' ${STREAM_QUERY_RESULT_DIR}/${query_name}.err |head -n $i|tail -n 1| sed -e 's/\[DEBUG\]://g'`
   echo $query_logview >> ${STREAM_QUERY_RESULT_DIR}/${result_file_name}
   grep -E '(ODPS-|FAILED:)' ${STREAM_QUERY_RESULT_DIR}/${query_name}.err >> ${STREAM_QUERY_RESULT_DIR}/${result_file_name}
   echo "Summary:" >> ${STREAM_QUERY_RESULT_DIR}/${result_file_name}
   subqueryId=`grep ', QueryId:' ${STREAM_QUERY_RESULT_DIR}/${query_name}.err |head -n $i|tail -n 1 |awk -F 'QueryId:' '{print $2}' |sed 's/ //g'`
   summary_tmp=`${ODPS_CLT_CMD} --project ${PROJECT} -e "session get sqlstats_${subqueryId}"`
   if [ "${summary_tmp}"x == ""x ]
   then
        sleep 3
         for i in {1..15}
       do
           summary_tmp=`${ODPS_CLT_CMD} --project ${PROJECT} -e "session get sqlstats_${subqueryId}"`
           if [ "${summary_tmp}"x == ""x ]
           then
               sleep 3
           else
               break
           fi
       done
   fi
   echo "${summary_tmp}" >> ${STREAM_QUERY_RESULT_DIR}/${result_file_name}; 
   cost=`grep 'sub-query cost time' ${STREAM_QUERY_RESULT_DIR}/${query_name}.err |head -n $i|tail -n 1 |awk -F 'cost time:' '{print $2}' |awk '{print $1}'|sed 's/ //g'`
   if [[ "$cost"x == ""x ]]
   then
   	cost=${ms}
   fi
   echo "start,$query_start_date,end,$query_end_date,cost,$cost" >> ${STREAM_QUERY_RESULT_DIR}/${result_file_name}
   echo "${query_name_new} start at $query_start_date, end at $query_end_date, cost $cost" >>${LOG_DIR}/stream_$1_timeing.log
   mv ${STREAM_QUERY_RESULT_DIR}/`echo $result_file_name |sed -e 's/.new//g'` ${STREAM_QUERY_RESULT_DIR}/query_running_log/
   mv ${STREAM_QUERY_RESULT_DIR}/${result_file_name} ${STREAM_QUERY_RESULT_DIR}/`echo $result_file_name |sed -e 's/.new//g'`
  done
  if [ ${query_num} -gt 1 ]
  then
  	echo "start,$query_start_date,end,$query_end_date,cost,$cost" >> ${STREAM_QUERY_RESULT_DIR}/${query_name}.err
  	mv ${STREAM_QUERY_RESULT_DIR}/${query_name}.err ${STREAM_QUERY_RESULT_DIR}/query_running_log/
  fi
else
   echo "fallback to offline mode!"
   echo "start,$query_start_date,end,$query_end_date,cost,$ms" >> ${STREAM_QUERY_RESULT_DIR}/${query_name}.err
   echo "$query_name start at $query_start_date, end at $query_end_date, cost $elapse_time" >>${LOG_DIR}/stream_$1_timeing.log
fi
else
   query_duration=$(((query_end - query_start) / 1000))
   ms=`bc <<< "scale=3; ($query_end - $query_start)"`
   elapse_time=`printf "%d:%02d:%02d, %s ms" $(($query_duration / 3600)) $((($query_duration / 60) % 60)) $(($query_duration % 60)) $ms`
   if [ "${MAXQA_QUOTA_NAME}"x == ""x ]
   then
       echo "config runing offline mode!"
       echo "start,$query_start_date,end,$query_end_date,cost,$ms" >> ${STREAM_QUERY_RESULT_DIR}/${query_name}.err
       echo "$query_name start at $query_start_date, end at $query_end_date, cost $elapse_time" >>${LOG_DIR}/stream_$1_timeing.log
   else
       echo "config running MAXQA mode!"
       query_logview=`grep 'logview' ${STREAM_QUERY_RESULT_DIR}/${query_name}.err |head -n $i|tail -n 1| sed -e 's/\[DEBUG\]://g'`
       #query_logview=`grep 'logview' ${STREAM_QUERY_RESULT_DIR}/${query_name}.err |head -n $i|tail -n 1`
       cost=`grep 'Query cost time' ${STREAM_QUERY_RESULT_DIR}/${query_name}.err |head -n $i|tail -n 1 |awk -F 'cost time:' '{print $2}' |awk '{print $1}'|sed 's/ //g'`
       sec=${cost}
       if [[ "$cost"x == ""x ]]
       then
        cost=${ms}
       fi
       echo "start,$query_start_date,end,$query_end_date,cost,$cost" >> ${STREAM_QUERY_RESULT_DIR}/${query_name}.err
       echo "$query_name start at $query_start_date, end at $query_end_date, cost $elapse_time" >>${LOG_DIR}/stream_$1_timeing.log
   fi
fi
 
echo ${query_name},${subqueryId},${sec},${query_logview} >>console_test_result.csv
done

if [ "${MODE}"x == "MCQA"x ]
then
	session_logview=`${ODPS_CLT_CMD} --project ${PROJECT} -e "wait;" 2>&1 | grep http`
	instanceId=`echo ${session_logview} |awk -F '&' '{print $3}'|awk -F '=' '{print $NF}'|sed 's/ //g'`
	${ODPS_CLT_CMD} --project ${PROJECT} -e "http get /projects/${PROJECT}/instances/${instanceId}?cached" > ${STREAM_QUERY_RESULT_DIR}/logview/substatus.txt

	quotaNickname=`grep 'quotaNickname' ${STREAM_QUERY_RESULT_DIR}/logview/substatus.txt | sed -e 's/,//g'`
	regionId=`grep 'regionId' ${STREAM_QUERY_RESULT_DIR}/logview/substatus.txt | sed -e 's/,//g'`
	taskName=`grep 'taskName' ${STREAM_QUERY_RESULT_DIR}/logview/substatus.txt | sed -e 's/,//g'`
	taskType=`grep 'taskType' ${STREAM_QUERY_RESULT_DIR}/logview/substatus.txt | sed -e 's/,//g'`
	userAccount=`grep 'userAccount' ${STREAM_QUERY_RESULT_DIR}/logview/substatus.txt | sed -e 's/,//g'`
	userName=`grep 'userName' ${STREAM_QUERY_RESULT_DIR}/logview/substatus.txt | sed -e 's/,//g'`
 
	echo 'project',${PROJECT} >>console_test_result.csv
	echo 'instanceId',${instanceId} >>console_test_result.csv
	echo ${quotaNickname} >>console_test_result.csv
	echo ${regionId} >>console_test_result.csvac
	echo ${taskName} >>console_test_result.csv
	echo ${taskType} >>console_test_result.csv
	echo ${userAccount} >>console_test_result.csv
	echo ${userName} >>console_test_result.csv
fi
echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` ,Run stream $1 finished. Time token: $elapse_time"

echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` ,generate stream $1 report starts."

cd ${WORK_DIR}/results
if [[ "${report_name}"x == ""x ]]
then
    sh generate_report.sh tpcds ${STREAM_QUERY_RESULT_DIR}/ ${STREAM_QUERY_DIR}/ stream_$1
else
    sh generate_report.sh tpcds ${STREAM_QUERY_RESULT_DIR}/ ${STREAM_QUERY_DIR}/ stream_$1 ${report_name}
fi

echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` ,generate stream $1 report ends."

