#!/bin/bash
set -e
set -x
source ./config
BUILD_DIR=$(cd `dirname $0`; pwd)
LOG_DIR=${BUILD_DIR}/logs
QUERY_DIR=${BUILD_DIR}/queries_${SF}
rm -rf ${QUERY_DIR}
mkdir -p ${QUERY_DIR}
LOG=${LOG_DIR}/querygen.log
> $LOG # clear the log
cd ${BUILD_DIR}
start=$(($(date +%s%N)/1000000))
#SEED=`date +%m%d%H%M%S%1N`
#keep query parameters stable
SEED=04122110121
echo "Seed is $SEED" | tee -a $LOG 2>&1

echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` ,Start to generate queries ..." | tee -a $LOG 2>&1

{

  echo "${BUILD_DIR}/${TOOLS_VERSION}"
  mkdir -p ${QUERY_DIR}
  
  cd ${BUILD_DIR}/${TOOLS_VERSION}/tools
  echo `./dsqgen -release 2>&1`

  ./dsqgen -directory ../query_templates -input ../query_templates/templates.lst -scale ${SF} -streams 9 -output_dir ${QUERY_DIR} -dialect maxcompute -rngseed $SEED
  for i in `seq 0 8`; do sed -i "s/##STREAMNUM##/$i/" ${QUERY_DIR}/query_$i.sql;STREAM_QUERY_DIR=${QUERY_DIR}/stream_$i;mkdir -p ${STREAM_QUERY_DIR} ;rm -rf ${STREAM_QUERY_DIR}/* ;python ${BUILD_DIR}/tools_file/split.py ${QUERY_DIR}/query_${i}.sql ${STREAM_QUERY_DIR}/; done
#  ./dsqgen -directory ../query_templates -input ../query_templates/templates.lst -scale 1 -QUALIFY Y -output_dir ${QUALIFY_QUERY} -dialect maxcompute
} >> $LOG 2>&1

end=$(($(date +%s%N)/1000000))
duration=$(( (end - start) / 1000))
sec=`bc <<< "scale=3; ($end - $start)/1000"`
elapse_time=`printf "%d:%02d:%02d, %s seconds" $(($duration / 3600)) $((($duration / 60) % 60)) $(($duration % 60)) $sec`
echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` ,Generate queries finished. Time token: $elapse_time" | tee -a $LOG 2>&1
