-- start query 13 in stream 0 using template query91.tpl
select  
        cc_call_center_id Call_Center,
        cc_name Call_Center_Name,
        cc_manager Manager,
        sum(cr_net_loss) Returns_Loss
from
        bigdata_public_dataset.tpcds_10t.call_center,
        bigdata_public_dataset.tpcds_10t.catalog_returns,
        bigdata_public_dataset.tpcds_10t.date_dim,
        bigdata_public_dataset.tpcds_10t.customer,
        bigdata_public_dataset.tpcds_10t.customer_address,
        bigdata_public_dataset.tpcds_10t.customer_demographics,
        bigdata_public_dataset.tpcds_10t.household_demographics
where
        cr_call_center_sk       = cc_call_center_sk
and     cr_returned_date_sk     = d_date_sk
and     cr_returning_customer_sk= c_customer_sk
and     cd_demo_sk              = c_current_cdemo_sk
and     hd_demo_sk              = c_current_hdemo_sk
and     ca_address_sk           = c_current_addr_sk
and     d_year                  = 2001 
and     d_moy                   = 11
and     ( (cd_marital_status       = 'M' and cd_education_status     = 'Unknown')
        or(cd_marital_status       = 'W' and cd_education_status     = 'Advanced Degree'))
and     hd_buy_potential like '0-500%'
and     ca_gmt_offset           = -7
group by cc_call_center_id,cc_name,cc_manager,cd_marital_status,cd_education_status
order by sum(cr_net_loss) desc;

-- end query 13 in stream 0 using template query91.tpl
