-- start query 58 in stream 0 using template query6.tpl
select  a.ca_state state, count(*) cnt
 from bigdata_public_dataset.tpcds_1t.customer_address a
     ,bigdata_public_dataset.tpcds_1t.customer c
     ,bigdata_public_dataset.tpcds_1t.store_sales s
     ,bigdata_public_dataset.tpcds_1t.date_dim d
     ,bigdata_public_dataset.tpcds_1t.item i
 where       a.ca_address_sk = c.c_current_addr_sk
 	and c.c_customer_sk = s.ss_customer_sk
 	and s.ss_sold_date_sk = d.d_date_sk
 	and s.ss_item_sk = i.i_item_sk
 	and d.d_month_seq = 
 	     (select distinct (d_month_seq)
 	      from bigdata_public_dataset.tpcds_1t.date_dim
               where d_year = 2001
 	        and d_moy = 1 )
 	and i.i_current_price > 1.2 * 
             (select avg(j.i_current_price) 
 	     from bigdata_public_dataset.tpcds_1t.item j 
 	     where j.i_category = i.i_category)
 group by a.ca_state
 having count(*) >= 10
 order by cnt, a.ca_state 
 limit 100;

-- end query 58 in stream 0 using template query6.tpl
