-- start query 90 in stream 0 using template query18.tpl
select  i_item_id,
        ca_country,
        ca_state, 
        ca_county,
        avg( cast(cs_quantity as decimal(12,2))) agg1,
        avg( cast(cs_list_price as decimal(12,2))) agg2,
        avg( cast(cs_coupon_amt as decimal(12,2))) agg3,
        avg( cast(cs_sales_price as decimal(12,2))) agg4,
        avg( cast(cs_net_profit as decimal(12,2))) agg5,
        avg( cast(c_birth_year as decimal(12,2))) agg6,
        avg( cast(cd1.cd_dep_count as decimal(12,2))) agg7
 from bigdata_public_dataset.tpcds_100g.catalog_sales, bigdata_public_dataset.tpcds_100g.customer_demographics cd1, 
      bigdata_public_dataset.tpcds_100g.customer_demographics cd2, bigdata_public_dataset.tpcds_100g.customer, bigdata_public_dataset.tpcds_100g.customer_address, bigdata_public_dataset.tpcds_100g.date_dim, bigdata_public_dataset.tpcds_100g.item
 where cs_sold_date_sk = d_date_sk and
       cs_item_sk = i_item_sk and
       cs_bill_cdemo_sk = cd1.cd_demo_sk and
       cs_bill_customer_sk = c_customer_sk and
       cd1.cd_gender = 'M' and 
       cd1.cd_education_status = 'Secondary' and
       c_current_cdemo_sk = cd2.cd_demo_sk and
       c_current_addr_sk = ca_address_sk and
       c_birth_month in (11,8,12,2,5,6) and
       d_year = 2002 and
       ca_state in ('ID','CO','GA'
                   ,'OH','ME','AR','OR')
 group by rollup (i_item_id, ca_country, ca_state, ca_county)
 order by ca_country,
        ca_state, 
        ca_county,
	i_item_id
 limit 100;

-- end query 90 in stream 0 using template query18.tpl
