-- start query 16 in stream 0 using template query27.tpl
select  i_item_id,
        s_state, grouping(s_state) g_state,
        avg(ss_quantity) agg1,
        avg(ss_list_price) agg2,
        avg(ss_coupon_amt) agg3,
        avg(ss_sales_price) agg4
 from bigdata_public_dataset.tpcds_10g.store_sales, bigdata_public_dataset.tpcds_10g.customer_demographics, bigdata_public_dataset.tpcds_10g.date_dim, bigdata_public_dataset.tpcds_10g.store, bigdata_public_dataset.tpcds_10g.item
 where ss_sold_date_sk = d_date_sk and
       ss_item_sk = i_item_sk and
       ss_store_sk = s_store_sk and
       ss_cdemo_sk = cd_demo_sk and
       cd_gender = 'M' and
       cd_marital_status = 'W' and
       cd_education_status = 'Unknown' and
       d_year = 1999 and
       s_state in ('MN','OH', 'AL', 'LA', 'NY', 'MI')
 group by rollup (i_item_id, s_state)
 order by i_item_id
         ,s_state
 limit 100;

-- end query 16 in stream 0 using template query27.tpl
