-- start query 25 in stream 0 using template query16.tpl
select  
   count(distinct cs_order_number) as `order count`
  ,sum(cs_ext_ship_cost) as `total shipping cost`
  ,sum(cs_net_profit) as `total net profit`
from
   bigdata_public_dataset.tpcds_1g.catalog_sales cs1
  ,bigdata_public_dataset.tpcds_1g.date_dim
  ,bigdata_public_dataset.tpcds_1g.customer_address
  ,bigdata_public_dataset.tpcds_1g.call_center
where
    d_date between '2001-4-01' and 
           (cast('2001-4-01' as date) + interval '60' day)
and cs1.cs_ship_date_sk = d_date_sk
and cs1.cs_ship_addr_sk = ca_address_sk
and ca_state = 'FL'
and cs1.cs_call_center_sk = cc_call_center_sk
and cc_county in ('Wadena County','Richland County','Bronx County','Marshall County',
                  'Luce County'
)
and exists (select *
            from bigdata_public_dataset.tpcds_1g.catalog_sales cs2
            where cs1.cs_order_number = cs2.cs_order_number
              and cs1.cs_warehouse_sk <> cs2.cs_warehouse_sk)
and not exists(select *
               from bigdata_public_dataset.tpcds_1g.catalog_returns cr1
               where cs1.cs_order_number = cr1.cr_order_number)
order by count(distinct cs_order_number)
limit 100;

-- end query 25 in stream 0 using template query16.tpl
