-- start query 55 in stream 0 using template query22.tpl
select  i_product_name
             ,i_brand
             ,i_class
             ,i_category
             ,avg(inv_quantity_on_hand) qoh
       from bigdata_public_dataset.tpcds_1g.inventory
           ,bigdata_public_dataset.tpcds_1g.date_dim
           ,bigdata_public_dataset.tpcds_1g.item
       where inv_date_sk=d_date_sk
              and inv_item_sk=i_item_sk
              and d_month_seq between 1199 and 1199 + 11
       group by rollup(i_product_name
                       ,i_brand
                       ,i_class
                       ,i_category)
order by qoh, i_product_name, i_brand, i_class, i_category
limit 100;

-- end query 55 in stream 0 using template query22.tpl
