/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.interaction.jetty.websocket.common;

import com.aliyun.odps.cupid.interaction.jetty.io.ByteBufferPool;
import com.aliyun.odps.cupid.interaction.jetty.util.annotation.ManagedAttribute;
import com.aliyun.odps.cupid.interaction.jetty.util.annotation.ManagedObject;
import com.aliyun.odps.cupid.interaction.jetty.util.component.ContainerLifeCycle;
import com.aliyun.odps.cupid.interaction.jetty.util.component.Dumpable;
import com.aliyun.odps.cupid.interaction.jetty.util.log.Log;
import com.aliyun.odps.cupid.interaction.jetty.util.log.Logger;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.BatchMode;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.CloseStatus;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.RemoteEndpoint;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.Session;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.SuspendToken;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.UpgradeRequest;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.UpgradeResponse;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.WebSocketBehavior;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.WebSocketException;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.WebSocketPolicy;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.extensions.ExtensionFactory;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.extensions.Frame;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.extensions.IncomingFrames;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.extensions.OutgoingFrames;
import com.aliyun.odps.cupid.interaction.jetty.websocket.common.CloseInfo;
import com.aliyun.odps.cupid.interaction.jetty.websocket.common.ConnectionState;
import com.aliyun.odps.cupid.interaction.jetty.websocket.common.LogicalConnection;
import com.aliyun.odps.cupid.interaction.jetty.websocket.common.SessionListener;
import com.aliyun.odps.cupid.interaction.jetty.websocket.common.WebSocketRemoteEndpoint;
import com.aliyun.odps.cupid.interaction.jetty.websocket.common.events.EventDriver;
import com.aliyun.odps.cupid.interaction.jetty.websocket.common.io.IOState;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

@ManagedObject(value="A Jetty WebSocket Session")
public class WebSocketSession
extends ContainerLifeCycle
implements Session,
IncomingFrames,
IOState.ConnectionStateListener {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private final URI requestURI;
    private final EventDriver websocket;
    private final LogicalConnection connection;
    private final SessionListener[] sessionListeners;
    private final Executor executor;
    private ClassLoader classLoader;
    private ExtensionFactory extensionFactory;
    private String protocolVersion;
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private WebSocketRemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private WebSocketPolicy policy;
    private UpgradeRequest upgradeRequest;
    private UpgradeResponse upgradeResponse;
    private BatchMode batchMode = BatchMode.AUTO;

    public WebSocketSession(URI requestURI, EventDriver websocket, LogicalConnection connection, SessionListener ... sessionListeners) {
        if (requestURI == null) {
            throw new RuntimeException("Request URI cannot be null");
        }
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.requestURI = requestURI;
        this.websocket = websocket;
        this.connection = connection;
        this.sessionListeners = sessionListeners;
        this.executor = connection.getExecutor();
        this.outgoingHandler = connection;
        this.incomingHandler = websocket;
        this.connection.getIOState().addListener(this);
    }

    @Override
    public void close() {
        this.connection.close(1000, null);
    }

    @Override
    public void close(CloseStatus closeStatus) {
        this.close(closeStatus.getCode(), closeStatus.getPhrase());
    }

    @Override
    public void close(int statusCode, String reason) {
        this.connection.close(statusCode, reason);
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        this.notifyClose(1006, "Harsh disconnect");
    }

    public void dispatch(Runnable runnable) {
        this.executor.execute(runnable);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        out.append(indent).append(" +- incomingHandler : ");
        if (this.incomingHandler instanceof Dumpable) {
            ((Dumpable)((Object)this.incomingHandler)).dump(out, indent + "    ");
        } else {
            out.append(this.incomingHandler.toString()).append(System.lineSeparator());
        }
        out.append(indent).append(" +- outgoingHandler : ");
        if (this.outgoingHandler instanceof Dumpable) {
            ((Dumpable)((Object)this.outgoingHandler)).dump(out, indent + "    ");
        } else {
            out.append(this.outgoingHandler.toString()).append(System.lineSeparator());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketSession other = (WebSocketSession)obj;
        return !(this.connection == null ? other.connection != null : !this.connection.equals(other.connection));
    }

    public ByteBufferPool getBufferPool() {
        return this.connection.getBufferPool();
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    @Override
    public long getIdleTimeout() {
        return this.connection.getMaxIdleTimeout();
    }

    @ManagedAttribute(readonly=true)
    public IncomingFrames getIncomingHandler() {
        return this.incomingHandler;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @ManagedAttribute(readonly=true)
    public OutgoingFrames getOutgoingHandler() {
        return this.outgoingHandler;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public RemoteEndpoint getRemote() {
        if (this.connection.getIOState().isOutputAvailable()) {
            return this.remote;
        }
        throw new WebSocketException("RemoteEndpoint unavailable, outgoing connection not open");
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remote.getInetSocketAddress();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    @Override
    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        return result;
    }

    @Override
    public void incomingError(Throwable t) {
        if (this.connection.getIOState().isInputAvailable()) {
            this.websocket.incomingError(t);
        }
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (this.connection.getIOState().isInputAvailable()) {
            this.incomingHandler.incomingFrame(frame);
        }
    }

    @Override
    public boolean isOpen() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isOpen();
    }

    @Override
    public boolean isSecure() {
        if (this.upgradeRequest == null) {
            throw new IllegalStateException("No valid UpgradeRequest yet");
        }
        URI requestURI = this.upgradeRequest.getRequestURI();
        return "wss".equalsIgnoreCase(requestURI.getScheme());
    }

    public void notifyClose(int statusCode, String reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifyClose({},{})", statusCode, reason);
        }
        this.websocket.onClose(new CloseInfo(statusCode, reason));
    }

    public void notifyError(Throwable cause) {
        this.incomingError(cause);
    }

    @Override
    public void onConnectionStateChange(ConnectionState state) {
        switch (state) {
            case CLOSED: {
                for (SessionListener listener : this.sessionListeners) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{}.onSessionClosed()", listener.getClass().getSimpleName());
                        }
                        listener.onSessionClosed(this);
                    }
                    catch (Throwable t) {
                        LOG.ignore(t);
                    }
                }
                IOState ioState = this.connection.getIOState();
                CloseInfo close = ioState.getCloseInfo();
                this.notifyClose(close.getStatusCode(), close.getReason());
                break;
            }
            case OPEN: {
                for (SessionListener listener : this.sessionListeners) {
                    try {
                        listener.onSessionOpened(this);
                    }
                    catch (Throwable t) {
                        LOG.ignore(t);
                    }
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        if (this.remote != null) {
            return;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.connection.getIOState().onConnected();
            BatchMode endpointBatchMode = this.websocket.getBatchMode();
            if (endpointBatchMode == null) {
                endpointBatchMode = this.getBatchMode();
            }
            this.remote = new WebSocketRemoteEndpoint(this.connection, this.outgoingHandler, endpointBatchMode);
            this.websocket.openSession(this);
            this.connection.getIOState().onOpened();
            if (LOG.isDebugEnabled()) {
                LOG.debug("open -> {}", this.dump());
            }
        }
        catch (Throwable t) {
            int statusCode = 1011;
            if (this.policy.getBehavior() == WebSocketBehavior.CLIENT) {
                statusCode = 1008;
            }
            this.close(statusCode, t.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void setExtensionFactory(ExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    @Override
    public void setIdleTimeout(long ms) {
        this.connection.setMaxIdleTimeout(ms);
    }

    public void setOutgoingHandler(OutgoingFrames outgoing) {
        this.outgoingHandler = outgoing;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }

    public void setUpgradeRequest(UpgradeRequest request) {
        this.upgradeRequest = request;
        this.protocolVersion = request.getProtocolVersion();
        this.parameterMap.clear();
        if (request.getParameterMap() != null) {
            for (Map.Entry<String, List<String>> entry : request.getParameterMap().entrySet()) {
                List<String> values = entry.getValue();
                if (values != null) {
                    this.parameterMap.put(entry.getKey(), values.toArray(new String[values.size()]));
                    continue;
                }
                this.parameterMap.put(entry.getKey(), new String[0]);
            }
        }
    }

    public void setUpgradeResponse(UpgradeResponse response) {
        this.upgradeResponse = response;
    }

    @Override
    public SuspendToken suspend() {
        return this.connection.suspend();
    }

    public BatchMode getBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(BatchMode mode) {
        this.batchMode = mode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[");
        builder.append("websocket=").append(this.websocket);
        builder.append(",behavior=").append((Object)this.policy.getBehavior());
        builder.append(",connection=").append(this.connection);
        builder.append(",remote=").append(this.remote);
        builder.append(",incoming=").append(this.incomingHandler);
        builder.append(",outgoing=").append(this.outgoingHandler);
        builder.append("]");
        return builder.toString();
    }
}

