/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.interaction;

import com.aliyun.odps.cupid.interaction.InteractionClient;
import com.aliyun.odps.cupid.interaction.InteractionSocket;
import com.aliyun.odps.cupid.interaction.jetty.websocket.api.Session;
import com.aliyun.odps.cupid.interaction.jetty.websocket.client.ClientUpgradeRequest;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.net.URI;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient
implements InteractionClient {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketClient.class);
    private InteractionSocket interactionSocket;
    private URI destUri;
    private String subProtocol;
    private String token;
    private String routeInfo;
    private String loadBalanceHashKey;
    private com.aliyun.odps.cupid.interaction.jetty.websocket.client.WebSocketClient client;

    WebSocketClient(URI destUri, String subProtocol, String token, int inputMode) {
        this.destUri = destUri;
        this.subProtocol = subProtocol;
        this.token = token;
        this.interactionSocket = new InteractionSocket(this, inputMode);
        this.connect(false);
    }

    public void connect(boolean isReconnect) {
        if (this.client == null) {
            this.client = new com.aliyun.odps.cupid.interaction.jetty.websocket.client.WebSocketClient();
        }
        try {
            if (!this.client.isStarted()) {
                this.client.start();
            }
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            request.setSubProtocols(this.subProtocol);
            this.setLoadBalanceKey(request);
            if (this.token != null) {
                request.setHeader("odps-cupid-proxy-token", this.token);
            }
            if (isReconnect) {
                request.setHeader("odps-cupid-proxy-reconnect", String.valueOf(System.currentTimeMillis()));
            }
            LOG.info(this.subProtocol + " - Connecting to : " + this.destUri);
            Future<Session> future = this.client.connect(this.interactionSocket, this.destUri, request);
            Session session = future.get(5L, TimeUnit.SECONDS);
            if (!isReconnect && "interaction_client".equals(this.subProtocol)) {
                this.token = session.getUpgradeResponse().getHeader("odps-cupid-proxy-token");
                this.routeInfo = session.getUpgradeResponse().getHeader("odps-cupid-proxy-route-info");
            }
            this.extractLoadBalanceKey(session);
            LOG.info(this.subProtocol + " - Connected!");
        }
        catch (Throwable t) {
            String errMsg = this.subProtocol + " - Websocket connect failed";
            LOG.error(errMsg, t);
            this.close();
        }
    }

    private void setLoadBalanceKey(ClientUpgradeRequest request) {
        if ("interaction_client".equals(this.subProtocol) && this.loadBalanceHashKey != null) {
            int cookieVersion = 0;
            String lbKey = this.loadBalanceHashKey;
            if (this.loadBalanceHashKey.contains("\"")) {
                cookieVersion = 1;
                lbKey = lbKey.replaceAll("\"", "");
            }
            HttpCookie cookie = new HttpCookie("route", lbKey);
            cookie.setVersion(cookieVersion);
            request.getCookies().add(cookie);
        }
    }

    private void extractLoadBalanceKey(Session session) {
        String setCookieValue = session.getUpgradeResponse().getHeader("Set-Cookie");
        if (setCookieValue != null) {
            String[] kv;
            setCookieValue = setCookieValue.trim();
            for (String kvStr : kv = setCookieValue.split(";")) {
                String[] kAndV;
                if (!kvStr.contains("=") || (kAndV = kvStr.split("=")).length != 2 || kAndV[0] == null || kAndV[1] == null || !"route".equals(kAndV[0].trim())) continue;
                this.loadBalanceHashKey = kAndV[1].trim();
                LOG.info(this.subProtocol + " - loadbalance key:" + this.loadBalanceHashKey);
                return;
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.interactionSocket.getInputStream();
    }

    @Override
    public void setInput(FileDescriptor fd) {
        this.interactionSocket.setInput(fd);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.interactionSocket.getOutputStream();
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getRouteInfo() {
        return this.routeInfo;
    }

    public String getSubProtocol() {
        return this.subProtocol;
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.interactionSocket.close();
    }

    @Override
    public boolean isClosed() {
        if (this.interactionSocket != null) {
            return this.interactionSocket.isClosed();
        }
        return true;
    }
}

