/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.interaction;

import com.aliyun.odps.cupid.interaction.InteractionClient;
import com.aliyun.odps.cupid.interaction.Protocol;
import com.aliyun.odps.cupid.interaction.WebSocketClient;
import java.net.URI;
import java.net.URISyntaxException;

public class InteractionClientFactory {
    public static InteractionClient getAppClient(String protocol, String hostWithPort, String token) {
        if (Protocol.WEBSOCKET.name().equalsIgnoreCase(protocol)) {
            try {
                WebSocketClient clent = new WebSocketClient(new URI("ws://" + hostWithPort + "/interaction/"), "interaction_app", token, 1);
                return clent;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(hostWithPort + " is a invalid host!");
            }
        }
        throw new RuntimeException(protocol + " is not supported now!");
    }

    public static InteractionClient getUserClient(String protocol, String proxyEndpoint) {
        if (Protocol.WEBSOCKET.name().equalsIgnoreCase(protocol)) {
            try {
                WebSocketClient clent = new WebSocketClient(new URI(proxyEndpoint), "interaction_client", null, 1);
                return clent;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid endpoint:" + proxyEndpoint);
            }
        }
        throw new RuntimeException(protocol + " is not supported now!");
    }
}

