/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.client.rpc;

import com.aliyun.odps.cupid.client.rpc.CupidClientRpcController;
import com.aliyun.odps.cupid.com.google.protobuf.Descriptors;
import com.aliyun.odps.cupid.com.google.protobuf.InvalidProtocolBufferException;
import com.aliyun.odps.cupid.com.google.protobuf.Message;
import com.aliyun.odps.cupid.com.google.protobuf.RpcCallback;
import com.aliyun.odps.cupid.com.google.protobuf.RpcController;
import com.aliyun.odps.cupid.com.google.protobuf.Service;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CupidRpcServiceHandler {
    private static final Logger LOG = Logger.getLogger(CupidRpcServiceHandler.class);
    private static CupidRpcServiceHandler INSTANCE = null;

    public static CupidRpcServiceHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CupidRpcServiceHandler();
        }
        return INSTANCE;
    }

    public ServiceHandlerResponse handle(Service service, int methodId, byte[] requestBody) {
        Descriptors.MethodDescriptor method = service.getDescriptorForType().getMethods().get(methodId);
        final ByteArrayOutputStream resOut = new ByteArrayOutputStream();
        CupidClientRpcController controller = new CupidClientRpcController();
        try {
            Message reqMessage = null;
            reqMessage = service.getRequestPrototype(method).newBuilderForType().mergeFrom(requestBody).build();
            final StringBuffer sb = new StringBuffer();
            RpcCallback<Message> callback = new RpcCallback<Message>(){

                @Override
                public void run(Message message) {
                    try {
                        message.writeTo(resOut);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"serialize protobuf rpc response fail", (Throwable)e);
                        sb.append("serialize protobuf rpc response fail: " + e);
                    }
                }
            };
            service.callMethod(method, controller, reqMessage, callback);
            if (!controller.failed() && sb.length() > 0) {
                controller.setFailed(sb.toString());
            }
        }
        catch (InvalidProtocolBufferException e) {
            controller.setFailed(e.toString());
        }
        return new ServiceHandlerResponse(controller, resOut.toByteArray());
    }

    public class ServiceHandlerResponse {
        private RpcController controller;
        private byte[] response;

        public RpcController getController() {
            return this.controller;
        }

        public byte[] getResponse() {
            return this.response;
        }

        ServiceHandlerResponse(RpcController controller, byte[] response) {
            this.controller = controller;
            this.response = response;
        }

        public boolean isFailed() {
            return this.controller.failed();
        }

        public String getFailedMessage() {
            return this.controller.errorText();
        }
    }
}

