/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.client.rpc;

import apsara.odps.cupid.client.protocol.CupidClientRpc;
import com.aliyun.odps.cupid.client.rpc.CupidClientRpcChannel;
import com.aliyun.odps.cupid.client.rpc.CupidRpcChannelProxy;
import com.aliyun.odps.cupid.client.rpc.CupidRpcServiceHandler;
import com.aliyun.odps.cupid.com.google.protobuf.InvalidProtocolBufferException;
import com.aliyun.odps.cupid.com.google.protobuf.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CupidRpcChannelProxyTest
extends CupidRpcChannelProxy {
    private static final Logger LOG = LoggerFactory.getLogger(CupidClientRpcChannel.class);
    private Service service;

    public CupidRpcChannelProxyTest(Service service) {
        this.service = service;
    }

    @Override
    public byte[] SyncCall(byte[] res) {
        CupidClientRpc.RpcProtocol rpcProtocol = null;
        try {
            rpcProtocol = CupidClientRpc.RpcProtocol.parseFrom(res);
            int methodId = rpcProtocol.getMethodId();
            byte[] requestBody = rpcProtocol.getRequestBody().toByteArray();
            CupidRpcServiceHandler.ServiceHandlerResponse serviceHandlerResponse = CupidRpcServiceHandler.getInstance().handle(this.service, methodId, requestBody);
            if (serviceHandlerResponse.isFailed()) {
                LOG.error("The rpc call error:" + serviceHandlerResponse.getFailedMessage());
            }
            return serviceHandlerResponse.getResponse();
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("The rpc call error:" + e.getMessage());
            return null;
        }
    }
}

