/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid;

import com.aliyun.odps.Odps;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.account.BearerTokenAccount;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidJobInstance;
import com.aliyun.odps.cupid.requestcupid.JobViewUtil;
import com.aliyun.odps.cupid.runtime.RuntimeContext;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class CupidSession {
    private Logger logger = Logger.getLogger(CupidSession.class);
    private CupidJobInstance cupidJobInstance = new CupidJobInstance("", false, new Object());
    public AtomicInteger saveId = null;
    public CupidConf conf = null;
    private Odps odps = null;
    private Object odpsLock = new Object();
    public String biz_id;
    public String flightingMajorVersion;
    private static Object confLock = new Object();
    private static CupidSession cupidSession = null;
    public static CupidConf globalConf = new CupidConf();

    public CupidSession(CupidConf conf) {
        this.conf = conf;
        this.biz_id = conf.get("com.aliyun.biz_id", "");
        this.flightingMajorVersion = conf.get("odps.task.major.version", null);
        this.saveId = new AtomicInteger(0);
        this.odps = this.initOdps();
        if (Boolean.parseBoolean(conf.get("odps.cupid.bearer.token.enable", "true")) && System.getenv("META_LOOKUP_NAME") != null) {
            long interval = Long.parseLong(conf.get("odps.cupid.bearer.token.refresh.interval.seconds", "600"));
            Timer timer = new Timer("BearerTokenRefresher", true);
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    CupidSession.this.refreshOdps();
                }
            }, 0L, interval * 1000L);
        }
    }

    public JobViewUtil jobView() {
        return new JobViewUtil(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Odps odps() {
        Object object = this.odpsLock;
        synchronized (object) {
            return this.odps;
        }
    }

    public void setJobLookupName(String lookUpName) {
        this.cupidJobInstance.lookupName = lookUpName;
    }

    public String getJobLookupName() {
        return this.cupidJobInstance.lookupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobRunning() {
        Object object = this.cupidJobInstance.jobRunningLock;
        synchronized (object) {
            this.cupidJobInstance.jobisRunning = true;
            this.cupidJobInstance.jobRunningLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJobRunning() throws InterruptedException {
        int waitAmStartTime = Integer.parseInt(this.conf.get("odps.cupid.wait.am.start.time", "600")) * 1000;
        Object object = this.cupidJobInstance.jobRunningLock;
        synchronized (object) {
            if (!this.cupidJobInstance.jobisRunning) {
                this.cupidJobInstance.jobRunningLock.wait(waitAmStartTime);
            }
        }
        return this.cupidJobInstance.jobisRunning;
    }

    private Account getAccount() {
        if (System.getenv("META_LOOKUP_NAME") != null && "true".equals(this.conf.get("odps.cupid.bearer.token.enable", "true").toLowerCase())) {
            try {
                return new BearerTokenAccount(RuntimeContext.get().getBearerToken());
            }
            catch (Exception ex) {
                this.logger.error((Object)String.format("initialize BearerTokenAccount failed with %s, fallback to use AliyunAccount", ex.getMessage()));
                return new AliyunAccount(this.conf.get("odps.access.id"), this.conf.get("odps.access.key"));
            }
            catch (Throwable error) {
                this.logger.error((Object)String.format("initialize BearerTokenAccount failed with %s, fallback to use AliyunAccount", error.getMessage()));
                return new AliyunAccount(this.conf.get("odps.access.id"), this.conf.get("odps.access.key"));
            }
        }
        return new AliyunAccount(this.conf.get("odps.access.id"), this.conf.get("odps.access.key"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshOdps() {
        this.logger.info((Object)"refresh odps object");
        Account account = this.getAccount();
        Object object = this.odpsLock;
        synchronized (object) {
            this.odps.setAccount(account);
        }
    }

    public Odps initOdps() {
        Account account = this.getAccount();
        Odps odps = new Odps(account);
        String lookupName = System.getenv("META_LOOKUP_NAME");
        if (lookupName == null) {
            odps.setEndpoint(this.conf.get("odps.end.point"));
        } else {
            odps.setEndpoint(this.conf.get("odps.runtime.end.point", this.conf.get("odps.end.point")));
        }
        odps.setDefaultProject(this.conf.get("odps.project.name"));
        String runningCluster = this.conf.get("odps.moye.job.runningcluster", "");
        if (!"".equals(runningCluster)) {
            this.logger.info((Object)("user set runningCluster = " + runningCluster));
            odps.instances().setDefaultRunningCluster(runningCluster);
        }
        return odps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConf(CupidConf conf) {
        Object object = confLock;
        synchronized (object) {
            globalConf = conf;
            confLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CupidConf getConf() throws InterruptedException {
        Object object = confLock;
        synchronized (object) {
            while (globalConf.getAll().length == 0) {
                confLock.wait(20000L);
            }
        }
        return globalConf;
    }

    public static void reset() {
        cupidSession = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CupidSession get() {
        Class<CupidSession> clazz = CupidSession.class;
        synchronized (CupidSession.class) {
            if (cupidSession == null) {
                try {
                    cupidSession = new CupidSession(CupidSession.getConf());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                String lookupName = System.getenv("META_LOOKUP_NAME");
                if (lookupName == null) {
                    lookupName = "";
                }
                cupidSession.setJobLookupName(lookupName);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cupidSession;
        }
    }
}

