/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.core.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IterableStream<T>
implements Iterable<T> {
    private static final int DEFAULT_BATCH_SIZE = 1;
    private static final IterableStream<Object> EMPTY = new IterableStream(new ArrayList());
    private final Iterable<T> iterable;

    public IterableStream(Iterable<T> iterable) {
        this.iterable = Objects.requireNonNull(iterable, "'iterable' cannot be null.");
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.iterable.spliterator(), false);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterable.iterator();
    }

    public static <T> IterableStream<T> of(Iterable<T> iterable) {
        if (iterable == null) {
            return EMPTY;
        }
        return new IterableStream<T>(iterable);
    }
}

