/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.unittest;

import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.mapred.conf.JobConf;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class RuntimeContext {
    private static final String LOCAL_RUN_DIR = "mr_ut_local_jobs";
    private static WareHouse wareHouse = WareHouse.getInstance();
    private static RuntimeContext INSTANCE = null;
    private String jobId;

    private RuntimeContext(String jobId, JobConf jobconf) throws IOException {
        this.jobId = jobId;
        wareHouse.setConfiguration((Configuration)jobconf);
        wareHouse.getConfiguration().set("odps.mapred.local.temp.dir", LOCAL_RUN_DIR);
        wareHouse.setJobName(jobId);
    }

    public static synchronized RuntimeContext create(String jobId, JobConf jobconf) throws IOException {
        INSTANCE = new RuntimeContext(jobId, jobconf);
        return INSTANCE;
    }

    public static WareHouse getWareHouse() {
        return wareHouse;
    }

    public boolean containsKey(String key) {
        return wareHouse.caintainsKey(key);
    }

    public String getJobId() {
        return this.jobId;
    }

    public File getJobDir() {
        return wareHouse.getJobDir().getJobDir();
    }

    public File getJobFile() {
        return wareHouse.getJobDir().getJobFile();
    }

    public File getInputDir(String tbl, String partSpec) {
        String folder = StringUtils.isEmpty((String)partSpec) ? tbl : tbl + "/" + partSpec;
        return wareHouse.getJobDir().getInputDir(folder);
    }

    public File getOutputDir(String label) {
        return wareHouse.getJobDir().getOutputDir(label);
    }

    public File getResourceDir() {
        return wareHouse.getJobDir().getResourceDir();
    }
}

