/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.local.utils;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.local.common.TableMeta;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.mapred.bridge.ErrorCode;
import com.aliyun.odps.mapred.bridge.utils.Validator;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import com.aliyun.odps.pipeline.Pipeline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LocalValidatorFactory {
    private static final int MAX_INPUT_TABLE_COUNT = 1024;
    private static final int MAX_DISTINCT_INPUT_TABLE = 64;
    private static final int MAX_RESOURCE_COUNT = 256;
    private static final int MAX_MAP_INSTANCE_COUNT = 99999;
    private static final int MIN_MEMORY_FOR_MAP_TAK = 256;
    private static final int MAX_MEMORY_FOR_MAP_TAK = 12288;
    private static final int MIN_MEMORY_FOR_REDUCE_TAK = 256;
    private static final int MAX_MEMORY_FOR_REDUCE_TAK = 12288;
    private static final int MIN_MEMORY_FOR_JVM = 256;
    private static final int MAX_MEMORY_FOR_JVM = 12288;
    private static final int MIN_FUNCTION_TIME_OUT = 1;
    private static final int MAX_FUNCTION_TIME_OUT = 3600;
    private static final int MIN_PRIORITY_VALUE = 0;
    private static final int MAX_PRIORITY_VALUE = 9;

    private static boolean validateColumns(String[] columns, Column[] schema, StringBuilder errorMsg) {
        int i;
        HashSet<String> schemaColums = new HashSet<String>();
        for (i = 0; i < schema.length; ++i) {
            schemaColums.add(schema[i].getName());
        }
        for (i = 0; i < columns.length; ++i) {
            if (schemaColums.contains(columns[i])) continue;
            errorMsg.append("Can't find column " + columns[i] + " from key schema.");
            return false;
        }
        return true;
    }

    static void throwException(ErrorCode e) throws OdpsException {
        throw new OdpsException(e.code, e.msg);
    }

    static void throwException(ErrorCode e, String info) throws OdpsException {
        throw new OdpsException(e.code, e.msg + ":" + info);
    }

    public static void throwException(ErrorCode e, Throwable cause) throws OdpsException {
        throw new OdpsException(e.code, e.msg, cause);
    }

    public static Validator getValidator(BridgeJobConf job) {
        CompositeValidator validator = new CompositeValidator();
        if (Pipeline.fromJobConf((JobConf)job) == null) {
            validator.addValidator(new ConfigValidator((JobConf)job));
        } else {
            validator.addValidator(new PipelineValidtor((JobConf)job));
        }
        validator.addValidator(new InputOutputValidator(job));
        validator.addValidator(new ResourceValidator((JobConf)job));
        return validator;
    }

    static class PipelineValidtor
    implements Validator {
        private Pipeline pipeline;

        public PipelineValidtor(JobConf job) {
            this.pipeline = Pipeline.fromJobConf((JobConf)job);
        }

        public void validate() throws OdpsException {
            if (this.pipeline == null) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Pipeline not specified.");
            }
            if (this.pipeline.getNodeNum() == 0) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Pipeline is empty.");
            }
            if (this.pipeline.getFirstNode().getType().equals("reduce")) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "First operator of pipeline must be mapper");
            }
            for (int i = 0; i < this.pipeline.getNodeNum(); ++i) {
                if (i > 0 && this.pipeline.getNode(i).getType().equals("map")) {
                    LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Operators after first node must be reducer");
                }
                if (i >= this.pipeline.getNodeNum() - 1) continue;
                if (this.pipeline.getNode(i).getOutputKeySchema() == null) {
                    LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Operator ouput key schema not set");
                }
                if (this.pipeline.getNode(i).getOutputValueSchema() != null) continue;
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Operator ouput value schema not set");
            }
            StringBuilder errorMsg = new StringBuilder();
            if (!this.validatePartitionColumns(this.pipeline, errorMsg)) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Key partition columns should be inside of output key columns. " + errorMsg);
            }
        }

        private boolean validatePartitionColumns(Pipeline pipeline, StringBuilder errorMsg) {
            Pipeline.TransformNode node = null;
            for (int i = 0; i < pipeline.getNodeNum() - 1; ++i) {
                node = pipeline.getNode(i);
                if (node.getPartitionerClass() != null || LocalValidatorFactory.validateColumns(node.getPartitionColumns(), node.getOutputKeySchema(), errorMsg)) continue;
                return false;
            }
            return true;
        }
    }

    static class ResourceValidator
    implements Validator {
        private JobConf job;

        public ResourceValidator(JobConf job) {
            this.job = job;
        }

        public void validate() throws OdpsException {
            String[] res = this.job.getResources();
            if (res == null || res.length <= 0) {
                return;
            }
            if (res.length > 256) {
                LocalValidatorFactory.throwException(ErrorCode.TOO_MANY_RESOURCE_ITEMS, "Acturally " + String.valueOf(res.length));
            }
        }
    }

    static class ConfigValidator
    implements Validator {
        private JobConf job;

        public ConfigValidator(JobConf job) {
            this.job = job;
        }

        private boolean between(long i, long l, long h) {
            return i <= h && i >= l;
        }

        public void validate() throws OdpsException {
            StringBuilder errorMsg;
            if (this.job.get("odps.mapred.map.class") == null) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Mapper class not specified.");
            }
            if (InputUtils.getTables((JobConf)this.job) == null && !this.between(this.job.getNumMapTasks(), 0L, 99999L)) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Map tasks " + this.job.getNumMapTasks() + " out of bound, shoud be in [0, " + 99999 + "] range.");
            }
            if (this.job.getNumReduceTasks() != 0 && this.job.get("odps.mapred.reduce.class") == null) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Reducer class not specified.");
            }
            if (this.job.getNumReduceTasks() != 0 && !this.validateSchema(this.job.getMapOutputKeySchema())) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Malformed map output key schema:" + this.job.get("odps.mapred.mapoutput.key.schema"));
            }
            if (this.job.getNumReduceTasks() != 0 && !this.validateSchema(this.job.getMapOutputValueSchema())) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Malformed map output value schema:" + this.job.get("odps.mapred.mapoutput.value.schema"));
            }
            if (!this.between(this.job.getMemoryForMapTask(), 256L, 12288L)) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Memory for map " + this.job.getMemoryForMapTask() + " out of bound, should be in [" + 256 + ", " + 12288 + "] range.");
            }
            if (!this.between(this.job.getMemoryForReduceTask(), 256L, 12288L)) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Memory for reduce " + this.job.getMemoryForReduceTask() + " out of bound, should be in [" + 256 + ", " + 12288 + "] range.");
            }
            if (!this.between(this.job.getMemoryForJVM(), 256L, 12288L)) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Memory for jvm " + this.job.getMemoryForJVM() + " out of bound, should be in [" + 256 + ", " + 12288 + "] range.");
            }
            if (this.job.getOutputKeySortColumns().length != this.job.getOutputKeySortOrder().length) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Key sort columns length should match key sort order length. Sort columns are " + Arrays.toString(this.job.getOutputKeySortColumns()) + " but sort order is " + Arrays.toString(this.job.getOutputKeySortOrder()));
            }
            if (!this.validatePartitionColumns(this.job, errorMsg = new StringBuilder())) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Key partition columns should be inside of output key columns. " + errorMsg);
            }
            if (!this.between(this.job.getFunctionTimeout(), 1L, 3600L)) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Function timeout " + this.job.getFunctionTimeout() + " out of bound, should be in [" + 1 + ", " + 3600 + "] range.");
            }
            if (!this.between(this.job.getInstancePriority(), 0L, 9L)) {
                LocalValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Instance priority" + this.job.getInstancePriority() + " out of bound, should be in [" + 0 + ", " + 9 + "] range.");
            }
        }

        private boolean validatePartitionColumns(JobConf job, StringBuilder errorMsg) {
            if (job.getNumReduceTasks() > 0 && job.getPartitionerClass() == null) {
                return LocalValidatorFactory.validateColumns(job.getPartitionColumns(), job.getMapOutputKeySchema(), errorMsg);
            }
            return true;
        }

        private boolean validateSchema(Column[] schema) {
            return schema != null && schema.length >= 1;
        }
    }

    static class InputOutputValidator
    implements Validator {
        private BridgeJobConf job;

        public InputOutputValidator(BridgeJobConf job) {
            this.job = job;
        }

        private void validateTable(TableInfo table, Map<String, TableMeta> distinctTables) throws OdpsException {
            LinkedHashMap partSpec;
            TableMeta tableDesc = distinctTables.get(table.getProjectName() + "." + table.getTableName());
            if (tableDesc == null) {
                if (!WareHouse.getInstance().existsTable(table.getProjectName(), table.getTableName())) {
                    LocalValidatorFactory.throwException(ErrorCode.TABLE_NOT_FOUND, table.toString());
                }
                tableDesc = WareHouse.getInstance().getTableMeta(table.getProjectName(), table.getTableName());
                distinctTables.put(table.getProjectName() + "." + table.getTableName(), tableDesc);
            }
            if ((partSpec = table.getPartSpec()) != null && partSpec.size() > 0) {
                Column[] cols = tableDesc.getPartitions();
                ArrayList<String> colNames = new ArrayList<String>();
                for (Column c : cols) {
                    colNames.add(c.getName());
                }
                for (String key : partSpec.keySet()) {
                    if (colNames.contains(key.toLowerCase())) continue;
                    LocalValidatorFactory.throwException(ErrorCode.PARTITION_COLUMN_NOT_FOUND, key);
                }
            }
            if (table.getCols() != null) {
                Column[] schema = tableDesc.getCols();
                HashSet<String> names = new HashSet<String>(Arrays.asList(table.getCols()));
                names.removeAll(Arrays.asList(SchemaUtils.getNames((Column[])schema)));
                if (!names.isEmpty()) {
                    LocalValidatorFactory.throwException(ErrorCode.COLUMN_NOT_FOUND, StringUtils.join(names, (String)","));
                }
            }
        }

        public void validate() throws OdpsException {
            TableInfo[] tables = InputUtils.getTables((JobConf)this.job);
            if (tables == null || tables.length < 1) {
                return;
            }
            if (tables.length > 1024) {
                LocalValidatorFactory.throwException(ErrorCode.TOO_MANY_INPUT_TABLE, "Expecting no more than 1024 partitions. ");
            }
            HashMap<String, TableMeta> distinctInputTables = new HashMap<String, TableMeta>();
            for (TableInfo table : tables) {
                this.validateTable(table, distinctInputTables);
                if (distinctInputTables.size() <= 64) continue;
                LocalValidatorFactory.throwException(ErrorCode.TOO_MANY_INPUT_TABLE, "Expecting no more than 64 distinct tables. ");
            }
            tables = OutputUtils.getTables((JobConf)this.job);
            if (tables == null || tables.length < 1) {
                return;
            }
            HashMap<String, TableMeta> distinctOutputTables = new HashMap<String, TableMeta>();
            HashSet<String> labelNames = new HashSet<String>();
            for (TableInfo table : tables) {
                this.validateTable(table, distinctOutputTables);
                if (labelNames.contains(table.getLabel())) {
                    LocalValidatorFactory.throwException(ErrorCode.OUTPUT_LABEL_NOT_UNIQUE, table.getLabel());
                }
                labelNames.add(table.getLabel());
            }
        }
    }

    static class CompositeValidator
    implements Validator {
        List<Validator> validators = new ArrayList<Validator>();

        CompositeValidator() {
        }

        public void addValidator(Validator v) {
            this.validators.add(v);
        }

        public void validate() throws OdpsException {
            for (Validator v : this.validators) {
                v.validate();
            }
        }
    }
}

