/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.local;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.local.utils.LocalColumnBasedRecordComparator;
import com.aliyun.odps.pipeline.Pipeline;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.commons.lang.ArrayUtils;

public class MapOutputBuffer {
    int[] partColIdxs;
    int numReduce;
    private List<PriorityQueue<Object[]>> buffers;
    Comparator<Object[]> comparator;

    public MapOutputBuffer(JobConf conf, int reduceNum) {
        Column[] key = conf.getMapOutputKeySchema();
        if (key != null) {
            String[] partCols = conf.getPartitionColumns();
            this.partColIdxs = new int[partCols.length];
            HashMap<String, Integer> reverseLookupMap = new HashMap<String, Integer>();
            int i = 0;
            for (Column column : key) {
                reverseLookupMap.put(column.getName(), i);
                ++i;
            }
            i = 0;
            for (String string : partCols) {
                this.partColIdxs[i] = (Integer)reverseLookupMap.get(string);
            }
            this.numReduce = reduceNum;
            String[] stringArray = conf.getOutputKeySortColumns();
            JobConf.SortOrder[] sortOrders = conf.getOutputKeySortOrder();
            this.comparator = new LocalColumnBasedRecordComparator(stringArray, key, sortOrders);
            this.buffers = new ArrayList<PriorityQueue<Object[]>>(this.numReduce);
            for (i = 0; i < this.numReduce; ++i) {
                this.buffers.add(new PriorityQueue<Object[]>(16, this.comparator));
            }
        }
    }

    public MapOutputBuffer(JobConf conf, Pipeline pipeline, String taskId, int reduceNum) {
        int pipeIndex = Integer.parseInt(taskId.split("_")[0].substring(1)) - 1;
        Pipeline.TransformNode pipeNode = pipeline.getNode(pipeIndex);
        Column[] key = pipeNode.getOutputKeySchema();
        if (key != null) {
            String[] partCols = pipeNode.getPartitionColumns();
            this.partColIdxs = new int[partCols.length];
            HashMap<String, Integer> reverseLookupMap = new HashMap<String, Integer>();
            int i = 0;
            for (Column column : key) {
                reverseLookupMap.put(column.getName(), i);
                ++i;
            }
            i = 0;
            for (String string : partCols) {
                this.partColIdxs[i] = (Integer)reverseLookupMap.get(string);
            }
            this.numReduce = reduceNum;
            String[] stringArray = pipeNode.getOutputKeySortColumns();
            JobConf.SortOrder[] sortOrders = pipeNode.getOutputKeySortOrder();
            this.comparator = new LocalColumnBasedRecordComparator(stringArray, key, sortOrders);
            this.buffers = new ArrayList<PriorityQueue<Object[]>>(this.numReduce);
            for (i = 0; i < this.numReduce; ++i) {
                this.buffers.add(new PriorityQueue<Object[]>(16, this.comparator));
            }
        }
    }

    protected int getPartition(Record key) {
        int partition = 0;
        for (int i : this.partColIdxs) {
            Object o = key.get(i);
            if (o != null) {
                partition = partition * 32 + o.hashCode();
                continue;
            }
            partition *= 32;
        }
        return Math.abs(partition) % this.numReduce;
    }

    public void add(Record key, Record value) {
        int partition = this.getPartition(key);
        this.buffers.get(partition).offer(ArrayUtils.addAll((Object[])((Object[])((WritableRecord)key).toWritableArray().clone()), (Object[])((Object[])((WritableRecord)value).toWritableArray().clone())));
    }

    public void add(Record key, Record value, int partition) {
        this.buffers.get(partition).offer(ArrayUtils.addAll((Object[])((Object[])((WritableRecord)key).toWritableArray().clone()), (Object[])((Object[])((WritableRecord)value).toWritableArray().clone())));
    }

    public Queue<Object[]> getPartitionQueue(int partition) {
        return this.buffers.get(partition);
    }

    public Comparator<? super Object[]> getComparator() {
        return this.comparator;
    }

    public long getTotalRecordCount() {
        if (this.buffers == null) {
            return 0L;
        }
        long totalCount = 0L;
        for (PriorityQueue<Object[]> item : this.buffers) {
            if (item == null) continue;
            totalCount += (long)item.size();
        }
        return totalCount;
    }

    public void add(Record record, String label) {
    }
}

